/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.control;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.xdja.pams.rptms.bean.QueryReportTemplateBean;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.service.AttachmentService;
import pams.function.xatl.ruyihu.service.IApplyMoneyService;
import pams.function.xatl.ruyihu.service.IBusinessTripService;
import pams.function.xatl.ruyihu.util.LakeMobUtils;
import pams.function.xatl.ruyihu.util.MyAssert;
import pams.function.xatl.ruyihu.util.QuickJson;

@Controller
public class CommonUploadController {
    public static final List<String> TYPES = Arrays.asList("anno", "doc", "leave", "apply_money");
    private Logger logger = LoggerFactory.getLogger(CommonUploadController.class);
    @Resource
    private AttachmentService attachmentService;
    @Resource
    private IApplyMoneyService applyMoneyService;
    @Resource
    private IBusinessTripService businessTripService;

    @RequestMapping(value={"ruyihu/commonUploadController/upload.do"})
    public void uplod(@RequestParam(required=true, value="files") List<MultipartFile> files, @RequestParam(required=false, value="type") String type, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (CollectionUtils.isEmpty(files)) {
            response.setStatus(400);
            response.getOutputStream().print("files is empty");
            return;
        }
        if (!StringUtils.hasText((String)type) || !TYPES.contains(type)) {
            type = "leave";
        }
        File parent = this.checkTmpAttachmentsDir(request);
        ArrayNode idList = QuickJson.newArrayNode();
        int i = 1;
        for (MultipartFile one : files) {
            if (!one.isEmpty()) {
                String uuid = LakeMobUtils.uuid();
                String originalName = one.getOriginalFilename();
                this.logger.info("receive file: " + originalName);
                int order = i++;
                long fileSize = one.getSize();
                File newFile = new File(parent, uuid + "." + Files.getFileExtension((String)originalName));
                one.transferTo(newFile);
                AttachmentEntity entity = new AttachmentEntity();
                entity.setCreateTime(LakeMobUtils.now());
                entity.setOrderNum(order);
                entity.setAttachmentUrl(newFile.getName());
                entity.setAttachmentName(originalName);
                entity.setAttachmentSize((int)fileSize);
                entity.setType(type);
                entity.setOwnerId("0");
                this.attachmentService.saveAttachment(entity);
                idList.add(entity.getAttachmentId());
                continue;
            }
            idList.add("");
        }
        ObjectNode jsonNodes = QuickJson.newObjectNode();
        jsonNodes.put("success", true).put("idList", (JsonNode)idList);
        response.setContentType("application/json");
        String json = jsonNodes.toString();
        response.getOutputStream().write(json.getBytes(Charsets.UTF_8));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("common upload response: " + json);
        }
    }

    @RequestMapping(value={"ruyihu/commonUploadController/pdf.do"})
    public void pdf(String type, String applyId, HttpServletResponse response) throws Exception {
        MyAssert.hasText(applyId, "applyId \u4e0d\u80fd\u4e3a\u7a7a");
        ServletOutputStream servletOutputStream = response.getOutputStream();
        byte[] bytes = null;
        String fileName = "";
        if (type.equals("apply_money")) {
            bytes = this.applyMoneyService.reportToPDF(applyId);
            fileName = "lakemob_apply_money";
        } else if (type.equals("business_trip")) {
            bytes = this.businessTripService.reportToPDF(applyId);
            fileName = "lakemob_business_trip";
        } else {
            MyAssert.isTrue(false, "\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        response.setContentType("application/pdf");
        response.setHeader("Content-Disposition", "attachment;fileName=" + fileName + DateFormatUtils.format((Date)LakeMobUtils.now(), (String)"yyyyMMddHHmmss") + ".pdf");
        response.setContentLength(bytes.length);
        servletOutputStream.write(bytes, 0, bytes.length);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    private File checkTmpAttachmentsDir(HttpServletRequest request) {
        MyAssert.hasText(QueryReportTemplateBean.ROOT_PATH, "ROOT_PATH\u4e0d\u80fd\u4e3a\u7a7a");
        File parent = new File(QueryReportTemplateBean.ROOT_PATH, "tmpAttacheDir");
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return parent;
    }

    @RequestMapping(value={"ruyihu/commonUploadController/manualClean.do"})
    public void manualClean(HttpServletRequest request, HttpServletResponse response) throws IOException {
        File file = this.checkTmpAttachmentsDir(request);
        this.attachmentService.cleanUnuseAttachment(LakeMobUtils.now(), file);
        response.setContentType("application/json");
        response.getOutputStream().write(QuickJson.newObjectNode().put("success", true).toString().getBytes(Charsets.UTF_8));
    }
}

