/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.dao.impl;

import com.google.common.collect.Lists;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import pams.function.xatl.ruyihu.dao.IApplyMoneyDao;
import pams.function.xatl.ruyihu.entity.ApplyMoneyEntity;
import pams.function.xatl.ruyihu.enums.ApplyMoneyStatusEnum;

@Repository
public class ApplyMoneyDaoImpl
implements IApplyMoneyDao {
    @Resource
    private BaseDao baseDao;

    @Override
    public void save(ApplyMoneyEntity applyMoney) {
        this.baseDao.saveOrUpdate((Object)applyMoney);
    }

    @Override
    public List<ApplyMoneyEntity> applyMoneyList(boolean isFinLeader, String currentUser, long timestamp, int pageSize) {
        ArrayList params = Lists.newArrayList();
        StringBuilder sb = new StringBuilder("select am.* from t_lakemob_apply_money am where 1=1");
        sb.append("   and (am.apply_id in (").append("   (select t1.apply_id from t_lakemob_apply_money t1 where t1.apply_user_id = ?)").append("     UNION ALL").append("   (select bj.business_id from t_lakemob_business_joiner bj where bj.person_id = ? and bj.business_type = ?)").append("  ) and am.status != ? ) ");
        params.add(currentUser);
        params.add(currentUser);
        params.add("apply_money");
        params.add(ApplyMoneyStatusEnum.DELETE.value);
        if (isFinLeader) {
            sb.append(" or am.status = ? ");
            params.add(ApplyMoneyStatusEnum.DONE.value);
        }
        if (timestamp > 0L) {
            sb.append(" and am.create_time < ?");
            params.add(new Date(timestamp));
        }
        sb.append(" order by am.create_time desc");
        return this.baseDao.getListBySQL(null, sb.toString(), params.toArray(), new Page(1, pageSize), ApplyMoneyEntity.class);
    }

    @Override
    public ApplyMoneyEntity get(String applyId) {
        return (ApplyMoneyEntity)this.baseDao.getObjectById(ApplyMoneyEntity.class, (Serializable)((Object)applyId));
    }

    @Override
    public List<ApplyMoneyEntity> applyMoneyList(Integer applyType, String applyDept, String projectName, Integer status, String startDate, String endDate, Page page) {
        StringBuilder sb = new StringBuilder("select am.* from t_lakemob_apply_money am").append("   where am.status != ? and am.apply_type = ? ");
        ArrayList params = Lists.newArrayList();
        params.add(ApplyMoneyStatusEnum.DELETE.value);
        params.add(applyType);
        if (StringUtils.isNotEmpty((CharSequence)applyDept)) {
            sb.append(" and am.apply_dept like ?");
            params.add("%" + StringUtils.trim((String)applyDept) + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)projectName)) {
            sb.append(" and am.project_name like ?");
            params.add("%" + StringUtils.trim((String)projectName) + "%");
        }
        if (null != status) {
            sb.append(" and am.status = ?");
            params.add(status);
        }
        if (StringUtils.isNotEmpty((CharSequence)startDate)) {
            sb.append(" and am.apply_date >= ?");
            params.add(startDate);
        }
        if (StringUtils.isNotEmpty((CharSequence)endDate)) {
            sb.append(" and am.apply_date <= ?");
            params.add(endDate);
        }
        sb.append(" order by am.create_time desc");
        String countSql = "select count(1) from (" + sb.toString() + ") t";
        return this.baseDao.getListBySQL(countSql, sb.toString(), params.toArray(), page, ApplyMoneyEntity.class);
    }
}

