/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.entity.DocumentEntity;
import pams.function.xatl.ruyihu.jsonrpc.LakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.DocumentService;
import pams.function.xatl.ruyihu.util.LakeMobUtils;
import pams.function.xatl.ruyihu.util.MyAssert;

@Service
public class GetDocumentListWithApproval
extends LakeMobMethod {
    @Resource
    private DocumentService documentService;

    @Override
    public Object execute0(String currentUser, SuperRequest request) {
        String titleLike = request.needText("titleLike", "");
        String statusVal = request.needText("status", "");
        String type = request.needText("type", "");
        String shortNameLike = request.needText("shortNameLike", "");
        String beginDate = request.needText("beginDate", "");
        String endDate = request.needText("endDate", "");
        long timestamp = request.needLong("timestamp", 0L);
        int pageSize = request.needInt("pageSize", 10);
        String status = null;
        if ("1".equals(statusVal)) {
            status = "doc_status_ing";
        } else if ("2".equals(statusVal)) {
            status = "doc_status_done";
        }
        Date begin = LakeMobUtils.parseDate(beginDate);
        Date end = LakeMobUtils.parseDate(endDate);
        if (StringUtils.hasText((String)type)) {
            MyAssert.isTrue(LakeMobUtils.DocumentTypeMap.containsKey(type), "type\u503c\u4e0d\u6b63\u786e");
        }
        List<DocumentEntity> datas = this.documentService.getTopDocumentListWithApproval(currentUser, timestamp, pageSize, titleLike, status, type, shortNameLike, begin, end);
        int count = this.documentService.countDocumentListWithApproval(currentUser, timestamp, titleLike, status, type, shortNameLike, begin, end);
        boolean dataEnd = count <= datas.size();
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        ArrayNode dataList = JsonNodeFactory.instance.arrayNode();
        for (DocumentEntity one : datas) {
            dataList.add((JsonNode)JsonNodeFactory.instance.objectNode().put("documentId", one.getDocumentId()).put("type", one.getDocumentType()).put("typeDesc", LakeMobUtils.DocumentTypeMap.get(one.getDocumentType())).put("title", one.getDocumentTitle()).put("issueDate", DateFormatUtils.format((Date)one.getIssueDate(), (String)"yyyy/MM/dd")).put("workflowDone", "doc_status_done".equals(one.getApprovalStatus())));
        }
        root.put("dataEnd", dataEnd);
        DocumentEntity last = (DocumentEntity)Iterables.getLast(datas, null);
        if (last != null) {
            root.put("timestamp", last.getCreateTime().getTime());
        } else {
            root.put("timestamp", 0);
        }
        root.put("dataList", (JsonNode)dataList);
        return root;
    }
}

