/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.entity.RegulationEntity;
import pams.function.xatl.ruyihu.jsonrpc.LakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.RegulationService;
import pams.function.xatl.ruyihu.util.QuickJson;

@Service
public class GetRegulationList
extends LakeMobMethod {
    @Resource
    private RegulationService regulationService;
    @Resource
    private FastDFSClientService fastDFSClientService;

    @Override
    public Object execute0(String currentUser, SuperRequest request) {
        String titleLike = request.needText("title", "");
        long timestamp = request.needLong("timestamp", 0L);
        int pageSize = request.needInt("pageSize", 10);
        List<RegulationEntity> datas = this.regulationService.getTopRegulationList(titleLike, timestamp, pageSize);
        boolean dataEnd = this.regulationService.countRegulation(titleLike, timestamp) <= datas.size();
        ObjectNode root = QuickJson.newObjectNode();
        ArrayNode dataList = QuickJson.newArrayNode();
        for (RegulationEntity one : datas) {
            dataList.add((JsonNode)QuickJson.newObjectNode().put("id", one.getRegulationId()).put("title", one.getRegulationTitle()).put("fileName", one.getFileName()).put("fileSize", one.getFileSize()).put("createTime", DateFormatUtils.format((Date)one.getCreateTime(), (String)"yyyy/MM/dd")).put("downloadUrl", this.fastDFSClientService.getRealDownloadUrl(one.getDownloadUrl())));
        }
        RegulationEntity last = (RegulationEntity)Iterables.getLast(datas, null);
        if (last != null) {
            root.put("timestamp", last.getCreateTime().getTime());
        } else {
            root.put("timestamp", 0);
        }
        root.put("dataEnd", dataEnd);
        root.put("dataList", (JsonNode)dataList);
        return root;
    }
}

