/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.entity.FlowAssociateEntity;
import pams.function.xatl.ruyihu.entity.LeaveEntity;
import pams.function.xatl.ruyihu.jsonrpc.LakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.FlowAssociateService;
import pams.function.xatl.ruyihu.service.LeaveQueryService;
import pams.function.xatl.ruyihu.service.impl.BusinessTripServiceImpl;
import pams.function.xatl.ruyihu.service.workflow.LakeMobWorkflowService;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.ruyihu.util.QuickJson;

@Service
public class ProcessLeaveApproval
extends LakeMobMethod {
    @Resource
    private LakeMobWorkflowService lakeMobWorkflowService;
    @Resource
    private FlowAssociateService flowAssociateService;
    @Resource
    private LeaveQueryService leaveQueryService;
    public static final Logger LOGGER = LoggerFactory.getLogger(ProcessLeaveApproval.class);

    @Override
    public Object execute0(String currentUser, SuperRequest request) {
        String taskId = request.needText("taskId");
        Task task = this.lakeMobWorkflowService.getTask(taskId);
        if (null == task) {
            throw new LakeMobException("\u8be5\u7533\u8bf7\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        String businessKey = this.lakeMobWorkflowService.getBusinessKey(task);
        if (!StringUtils.hasText((String)businessKey)) {
            throw new LakeMobException("\u8be5\u7533\u8bf7\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        LeaveEntity leave = this.leaveQueryService.getLeaveById(businessKey);
        if (null == leave) {
            throw new LakeMobException("\u8be5\u7533\u8bf7\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        boolean pass = request.needBool("pass");
        String leaveId = request.needText("leaveId");
        List<FlowAssociateEntity> flowAssociateList = this.flowAssociateService.getFlowAssociateListByLeaveId(leaveId);
        if (flowAssociateList == null || flowAssociateList.size() == 0) {
            LOGGER.info("\u975e\u6d41\u7a0b\u5ba1\u6279\u4eba\u5458\u3002leaveId:" + leaveId + ", userId:" + currentUser);
            throw new LakeMobException("\u975e\u6d41\u7a0b\u5ba1\u6279\u4eba\u5458\u4e0d\u80fd\u5ba1\u6279");
        }
        FlowAssociateEntity personFlowAssociateEntity = null;
        for (FlowAssociateEntity flowAssociateEntity : flowAssociateList) {
            if (!flowAssociateEntity.getPersonId().equals(currentUser)) continue;
            personFlowAssociateEntity = flowAssociateEntity;
            break;
        }
        if (personFlowAssociateEntity == null) {
            LOGGER.info("\u975e\u6d41\u7a0b\u5ba1\u6279\u4eba\u5458\u3002leaveId:" + leaveId + ", userId:" + currentUser);
            throw new LakeMobException("\u975e\u6d41\u7a0b\u5ba1\u6279\u4eba\u5458\u4e0d\u80fd\u5ba1\u6279");
        }
        if ("1".equals(personFlowAssociateEntity.getProcessStatus())) {
            LOGGER.info("\u5df2\u5ba1\u6279\u8fc7\u4e0d\u80fd\u91cd\u590d\u5ba1\u6279\u3002leaveId:" + leaveId + ", userId:" + currentUser);
            throw new LakeMobException("\u5df2\u5ba1\u6279\u8fc7\u4e0d\u80fd\u91cd\u590d\u5ba1\u6279");
        }
        boolean success = this.lakeMobWorkflowService.completeLeaveApprovalTask(currentUser, taskId, pass);
        ObjectNode rst = QuickJson.newObjectNode();
        rst.put("revoked", !success);
        BusinessTripServiceImpl.leaveApplyListNewStatusMap.put(leaveId, false);
        BusinessTripServiceImpl.leaveApproveListNewStatusMap.put(leaveId, true);
        return rst;
    }
}

