/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.xdja.pams.bims.service.UserManageService;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.xatl.ruyihu.dao.AttachmentDao;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.service.AttachmentService;

@Service
public class AttachmentServiceImpl
implements AttachmentService {
    private Logger logger = LoggerFactory.getLogger(AttachmentServiceImpl.class);
    @Resource
    private UserManageService userManageService;
    @Resource
    private AttachmentDao attachmentDao;

    @Override
    public List<AttachmentEntity> getAttachmentListByOwnerId(String documentId, String type) {
        return this.attachmentDao.getAttachmentListByOwnerId(documentId, type);
    }

    @Override
    @Transactional
    public AttachmentEntity saveAttachment(AttachmentEntity entity) {
        this.attachmentDao.saveAttachment(entity);
        return entity;
    }

    @Override
    @Transactional
    public void cleanUnuseAttachment(Date date, File parent) {
        List<AttachmentEntity> list = this.attachmentDao.getUnuseAttachmentList(date, null);
        for (AttachmentEntity one : list) {
            File file = new File(parent, one.getAttachmentUrl());
            try {
                this.logger.debug("will clean tmp file: {}", (Object)file.getAbsolutePath());
                if (file.exists()) {
                    FileUtils.deleteQuietly((File)file);
                }
                this.attachmentDao.deleteAttachment(one);
            }
            catch (Exception e) {
                this.logger.warn("clean tmp file: {} failure, reason: {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
            }
        }
    }

    @Override
    public AttachmentEntity getUnuseAttachment(String one, String type) {
        return this.attachmentDao.getUnuseAttachment(one, type);
    }

    @Override
    public AttachmentEntity getUnuseAttachment(String attach) {
        return this.attachmentDao.getUnuseAttachment(attach);
    }
}

