/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.google.common.collect.Lists;
import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperRunManager;
import org.activiti.engine.task.Task;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import pams.function.xatl.ruyihu.bean.BusinessTripDateBean;
import pams.function.xatl.ruyihu.bean.BusinessTripDetailBean;
import pams.function.xatl.ruyihu.bean.BusinessTripInfo;
import pams.function.xatl.ruyihu.bean.BusinessTripListNode;
import pams.function.xatl.ruyihu.dao.ElectronicSignDao;
import pams.function.xatl.ruyihu.dao.FlowAssociateDao;
import pams.function.xatl.ruyihu.dao.FlowTraceDao;
import pams.function.xatl.ruyihu.dao.IBusinessTripDao;
import pams.function.xatl.ruyihu.dao.IFlowNoticeDao;
import pams.function.xatl.ruyihu.entity.BusinessTripEntity;
import pams.function.xatl.ruyihu.entity.ElectronicSignEntity;
import pams.function.xatl.ruyihu.entity.FlowAssociateEntity;
import pams.function.xatl.ruyihu.entity.FlowNoticeEntity;
import pams.function.xatl.ruyihu.entity.FlowTraceEntity;
import pams.function.xatl.ruyihu.enums.BusinessTripStatusEnum;
import pams.function.xatl.ruyihu.service.AuthService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.IBusinessTripService;
import pams.function.xatl.ruyihu.service.LakeMobPushService;
import pams.function.xatl.ruyihu.service.workflow.LakeMobWorkflowService;
import pams.function.xatl.ruyihu.util.LakeMobUtils;
import pams.function.xatl.ruyihu.util.MyAssert;

@Service
public class BusinessTripServiceImpl
implements IBusinessTripService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IBusinessTripDao businessTripDao;
    @Resource
    private FlowAssociateDao flowAssociateDao;
    @Resource
    private IFlowNoticeDao flowNoticeDao;
    @Resource
    private LakeMobWorkflowService lakeMobWorkflowService;
    @Resource
    private FlowTraceDao flowTraceDao;
    @Resource
    private PersonDao personDao;
    @Resource
    private FastDFSClientService fastDFSClientService;
    @Resource
    private ElectronicSignDao electronicSignDao;
    @Resource
    private AuthService authService;
    @Resource
    private LakeMobPushService lakeMobPushService;
    public static Map<String, Boolean> businessTripApplyNewStatusMap = new HashMap<String, Boolean>();
    public static Map<String, Boolean> businessTripApplyListNewStatusMap = new HashMap<String, Boolean>();
    public static Map<String, Boolean> businessTripApproveNewStatusMap = new HashMap<String, Boolean>();
    public static Map<String, Boolean> leaveApplyNewStatusMap = new HashMap<String, Boolean>();
    public static Map<String, Boolean> leaveApplyListNewStatusMap = new HashMap<String, Boolean>();
    public static Map<String, Boolean> leaveApproveNewStatusMap = new HashMap<String, Boolean>();
    public static Map<String, Boolean> leaveApproveListNewStatusMap = new HashMap<String, Boolean>();

    @Override
    @Transactional
    public String applyBusinessTrip(BusinessTripInfo businessTripInfo) {
        this.logger.debug("\u63d0\u4ea4\u51fa\u5dee\u7533\u8bf7");
        BusinessTripEntity businessTripEntity = new BusinessTripEntity();
        BeanUtils.copyProperties((Object)businessTripInfo, (Object)businessTripEntity, (String[])new String[]{"startDate", "endDate"});
        try {
            businessTripEntity.setStartDate(Util.parseDate((String)businessTripInfo.getStartDate(), (String)"yyyy-MM-dd"));
            businessTripEntity.setEndDate(Util.parseDate((String)businessTripInfo.getEndDate(), (String)"yyyy-MM-dd"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.businessTripDao.save(businessTripEntity);
        int order = 1;
        List<String> deptLeader = businessTripInfo.getDeptLeader();
        if (!CollectionUtils.isEmpty(deptLeader)) {
            for (String string : deptLeader) {
                FlowAssociateEntity flowAssociateEntity = new FlowAssociateEntity();
                flowAssociateEntity.setBusinessId(businessTripEntity.getApplyId());
                flowAssociateEntity.setBusinessType("business_trip");
                flowAssociateEntity.setTaskKey("deptLeaderTask");
                flowAssociateEntity.setCreateTime(LakeMobUtils.now());
                flowAssociateEntity.setOrderNum(order++);
                flowAssociateEntity.setPersonId(string);
                flowAssociateEntity.setProcessStatus("0");
                this.flowAssociateDao.saveFlowAssociate(flowAssociateEntity);
            }
        }
        order = 1;
        List<String> directLeader = businessTripInfo.getDirectLeader();
        if (!CollectionUtils.isEmpty(directLeader)) {
            for (String string : directLeader) {
                FlowAssociateEntity flowAssociateEntity = new FlowAssociateEntity();
                flowAssociateEntity.setBusinessId(businessTripEntity.getApplyId());
                flowAssociateEntity.setBusinessType("business_trip");
                flowAssociateEntity.setTaskKey("directLeaderTask");
                flowAssociateEntity.setCreateTime(LakeMobUtils.now());
                flowAssociateEntity.setOrderNum(order++);
                flowAssociateEntity.setPersonId(string);
                flowAssociateEntity.setProcessStatus("0");
                this.flowAssociateDao.saveFlowAssociate(flowAssociateEntity);
            }
        }
        order = 1;
        List<String> list = businessTripInfo.getMainLeader();
        if (!CollectionUtils.isEmpty(list)) {
            for (String personId : list) {
                FlowAssociateEntity flowAssociateEntity = new FlowAssociateEntity();
                flowAssociateEntity.setBusinessId(businessTripEntity.getApplyId());
                flowAssociateEntity.setBusinessType("business_trip");
                flowAssociateEntity.setTaskKey("mainLeaderTask");
                flowAssociateEntity.setCreateTime(LakeMobUtils.now());
                flowAssociateEntity.setOrderNum(order++);
                flowAssociateEntity.setPersonId(personId);
                flowAssociateEntity.setProcessStatus("0");
                this.flowAssociateDao.saveFlowAssociate(flowAssociateEntity);
            }
        }
        String string = this.lakeMobWorkflowService.startBusinessTripWorkflow(businessTripInfo, businessTripEntity.getApplyId());
        businessTripEntity.setWorkflowId(string);
        businessTripEntity.setStatus(BusinessTripStatusEnum.ING.value);
        this.businessTripDao.save(businessTripEntity);
        return businessTripEntity.getApplyId();
    }

    @Override
    public BusinessTripEntity get(String applyId) {
        return this.businessTripDao.get(applyId);
    }

    @Override
    public void doneBusinessTrip(String applyId, boolean revoked, boolean pass) {
        BusinessTripEntity businessTrip = this.businessTripDao.get(applyId);
        if (businessTrip.getStatus() == BusinessTripStatusEnum.DELETE.value) {
            return;
        }
        if (revoked) {
            businessTrip.setStatus(BusinessTripStatusEnum.REVOKE.value);
        } else if (!pass) {
            businessTrip.setStatus(BusinessTripStatusEnum.REFUSE.value);
        } else {
            businessTrip.setStatus(BusinessTripStatusEnum.DONE.value);
        }
        businessTrip.setDoneTime(LakeMobUtils.now());
        this.businessTripDao.save(businessTrip);
        if (businessTrip.getStatus() == BusinessTripStatusEnum.DONE.value) {
            FlowNoticeEntity fn2 = new FlowNoticeEntity();
            fn2.setBusinessId(applyId);
            fn2.setPersonId(businessTrip.getApplyUserId());
            fn2.setBusinessType("business_trip");
            this.flowNoticeDao.save(fn2);
            ArrayList ids2 = Lists.newArrayList();
            ids2.add(businessTrip.getApplyUserId());
            this.lakeMobPushService.pushBusinessTripApply(ids2, "\u60a8\u6536\u5230\u65b0\u7684\u51fa\u5dee\u7533\u8bf7\u5ba1\u6279\u7ed3\u679c");
            for (String id : ids2) {
                businessTripApproveNewStatusMap.put(id, true);
            }
        }
    }

    @Override
    public List<BusinessTripListNode> businessTripList(boolean isOfficeLeader, String currentUser, long timestamp, int pageSize, int businessUserType) {
        List<BusinessTripEntity> list = this.businessTripDao.businessTripList(isOfficeLeader, currentUser, timestamp, pageSize, businessUserType);
        ArrayList result = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(list)) {
            for (BusinessTripEntity entity : list) {
                BusinessTripListNode listNode = new BusinessTripListNode();
                listNode.setApplyId(entity.getApplyId());
                listNode.setTripUserId(entity.getTripUserId());
                Person person = this.personDao.queryPersonById(entity.getTripUserId());
                if (null != person) {
                    listNode.setTripUserName(person.getName());
                }
                listNode.setCreateTime(entity.getCreateTime().getTime());
                listNode.setStartDate(Util.getDate((String)"yyyy-MM-dd", (Date)entity.getStartDate()));
                listNode.setStatus(entity.getStatus());
                Task task = this.lakeMobWorkflowService.getTask(currentUser, entity.getWorkflowId(), "lakemob_business_trip");
                if (null != task && !task.getTaskDefinitionKey().equals("revokeTask")) {
                    listNode.setStatus(BusinessTripStatusEnum.WAIT.value);
                }
                boolean isNew = true;
                List<FlowNoticeEntity> flowNotice = this.flowNoticeDao.get(entity.getApplyId(), "business_trip", currentUser);
                if (CollectionUtils.isEmpty(flowNotice)) {
                    isNew = false;
                }
                if (2 == businessUserType && !isNew) {
                    isNew = businessTripApplyListNewStatusMap.containsKey(entity.getApplyId()) ? businessTripApplyListNewStatusMap.get(entity.getApplyId()) : false;
                }
                listNode.setIsNew(isNew);
                listNode.setCreateTimeStr(Util.getDate((String)"yyyy-MM-dd HH:mm", (Date)entity.getCreateTime()));
                result.add(listNode);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> businessTripNewStatus(boolean isOfficeLeader, String currentUser, long timestamp, int pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        boolean applyNewStatus = businessTripApplyNewStatusMap.containsKey(currentUser) ? businessTripApplyNewStatusMap.get(currentUser) : false;
        boolean approveNewStatus = businessTripApproveNewStatusMap.containsKey(currentUser) ? businessTripApproveNewStatusMap.get(currentUser) : false;
        result.put("businessTripApply", applyNewStatus);
        result.put("businessTripApprove", approveNewStatus);
        boolean leaveApply = leaveApplyNewStatusMap.containsKey(currentUser) ? leaveApplyNewStatusMap.get(currentUser) : false;
        boolean leaveApprove = leaveApproveNewStatusMap.containsKey(currentUser) ? leaveApproveNewStatusMap.get(currentUser) : false;
        result.put("leaveApply", leaveApply);
        result.put("leaveApprove", leaveApprove);
        return result;
    }

    private boolean getIsNewStatus(String currentUser, List<BusinessTripDetailBean> businessTripDetailBeanList) {
        boolean isNew = false;
        if (!CollectionUtils.isEmpty(businessTripDetailBeanList)) {
            for (BusinessTripDetailBean businessTripDetailBean : businessTripDetailBeanList) {
                List<FlowNoticeEntity> flowNotice = this.flowNoticeDao.get(businessTripDetailBean.getApplyId(), "business_trip", currentUser);
                if (CollectionUtils.isEmpty(flowNotice)) continue;
                isNew = true;
                break;
            }
        }
        return isNew;
    }

    @Override
    public BusinessTripDetailBean businessTripDetail(String currentUser, String applyId) {
        List<FlowNoticeEntity> list;
        BusinessTripEntity businessTripEntity = this.businessTripDao.get(applyId);
        BusinessTripDetailBean businessTripDetail = new BusinessTripDetailBean();
        BeanUtils.copyProperties((Object)businessTripEntity, (Object)businessTripDetail, (String[])new String[]{"startDate", "endDate"});
        businessTripDetail.setStartDate(Util.getDate((String)"yyyy-MM-dd", (Date)businessTripEntity.getStartDate()));
        businessTripDetail.setEndDate(Util.getDate((String)"yyyy-MM-dd", (Date)businessTripEntity.getEndDate()));
        businessTripDetail.setCreateTimeStr(Util.getDate((String)"yyyy-MM-dd HH:mm", (Date)businessTripEntity.getCreateTime()));
        Person person = this.personDao.queryPersonById(businessTripEntity.getTripUserId());
        if (null != person) {
            businessTripDetail.setTripUserName(person.getName());
        }
        boolean deleteNotic = true;
        List<FlowAssociateEntity> flowAssociateList = this.flowAssociateDao.getFlowAssociateListByBusinessTypeAndId("business_trip", applyId);
        ArrayList workflowPersonList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(flowAssociateList)) {
            ArrayList deptLeader = Lists.newArrayList();
            ArrayList directorLeader = Lists.newArrayList();
            ArrayList mainLeader = Lists.newArrayList();
            for (FlowAssociateEntity flowAssociateEntity : flowAssociateList) {
                if (StringUtils.isEmpty((CharSequence)currentUser) || flowAssociateEntity.getPersonId().equals(currentUser) && flowAssociateEntity.getProcessStatus().equals("0") && businessTripEntity.getStatus() != BusinessTripStatusEnum.REVOKE.value) {
                    deleteNotic = false;
                }
                if (flowAssociateEntity.getTaskKey().equals("deptLeaderTask")) {
                    deptLeader.add(this.flowAssociate2Map(flowAssociateEntity));
                    continue;
                }
                if (flowAssociateEntity.getTaskKey().equals("directLeaderTask")) {
                    directorLeader.add(this.flowAssociate2Map(flowAssociateEntity));
                    continue;
                }
                if (!flowAssociateEntity.getTaskKey().equals("mainLeaderTask")) continue;
                mainLeader.add(this.flowAssociate2Map(flowAssociateEntity));
            }
            workflowPersonList.addAll(deptLeader);
            workflowPersonList.addAll(directorLeader);
            workflowPersonList.addAll(mainLeader);
        }
        businessTripDetail.setWorkflowPersonList(workflowPersonList);
        ArrayList workflowTraceList = Lists.newArrayList();
        FlowTraceEntity start = new FlowTraceEntity();
        start.setTraceId("0");
        start.setPersonId(businessTripEntity.getApplyUserId());
        start.setCreateTime(businessTripEntity.getCreateTime());
        workflowTraceList.add(this.flowTrace2map(start));
        List<FlowTraceEntity> flowTraces = this.flowTraceDao.getFlowTraceListByBusinessTypeAndId("business_trip", applyId);
        boolean canRevoke = false;
        if (!CollectionUtils.isEmpty(flowTraces)) {
            for (FlowTraceEntity flowTrace : flowTraces) {
                if (flowTrace.getTaskKey().equals("revokeTask")) {
                    FlowTraceEntity revoke = new FlowTraceEntity();
                    BeanUtils.copyProperties((Object)flowTrace, (Object)revoke);
                    revoke.setTraceId("-1");
                    workflowTraceList.add(this.flowTrace2map(revoke));
                    continue;
                }
                workflowTraceList.add(this.flowTrace2map(flowTrace));
            }
        } else {
            canRevoke = true;
        }
        businessTripDetail.setCanRevoke(canRevoke);
        businessTripDetail.setWorkflowTraceList(workflowTraceList);
        if (deleteNotic && !CollectionUtils.isEmpty(list = this.flowNoticeDao.get(applyId, "business_trip", currentUser))) {
            this.flowNoticeDao.delete(applyId, "business_trip", currentUser);
        }
        Date date = businessTripEntity.getRealStartDate();
        Date realEndDate = businessTripEntity.getRealEndDate();
        if (date != null && realEndDate != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String personId = businessTripEntity.getTripUserId();
            Person applyPerson = this.personDao.queryPersonById(personId);
            map.put("personName", applyPerson.getName());
            map.put("realStartDateStr", Util.getDate((String)"yyyy/MM/dd", (Date)businessTripEntity.getRealStartDate()));
            map.put("realEndDateStr", Util.getDate((String)"yyyy/MM/dd", (Date)businessTripEntity.getRealEndDate()));
            map.put("tripReason", businessTripEntity.getTripReason());
            businessTripDetail.setTripDetail(map);
            HashMap<String, String> traceMap = new HashMap<String, String>();
            traceMap.put("id", "2");
            traceMap.put("createTime", Util.getDate((String)"yyyy/MM/dd HH:mm:ss", (Date)businessTripEntity.getUpdateTime()));
            traceMap.put("personId", personId);
            traceMap.put("personName", applyPerson.getName());
            traceMap.put("statusDesc", "\u5df2\u5b8c\u6210");
            workflowTraceList.add(traceMap);
            businessTripDetail.setWorkflowTraceList(workflowTraceList);
        }
        return businessTripDetail;
    }

    @Override
    @Transactional
    public void delete(String applyId) {
        BusinessTripEntity businessTrip = this.businessTripDao.get(applyId);
        businessTrip.setStatus(BusinessTripStatusEnum.DELETE.value);
        this.businessTripDao.save(businessTrip);
        this.flowNoticeDao.delete(applyId, "business_trip");
        this.lakeMobWorkflowService.delete(applyId, "lakemob_business_trip");
    }

    @Override
    public List<BusinessTripEntity> businessTripList(String personNameLike, Integer approvalStatus, Date begin, Date end, Page pageParam) {
        return this.businessTripDao.businessTripList(personNameLike, approvalStatus, begin, end, pageParam);
    }

    @Override
    public byte[] reportToPDF(String applyId) throws Exception {
        BusinessTripEntity businessTrip = this.businessTripDao.get(applyId);
        MyAssert.notNull(businessTrip, "\u51fa\u5dee\u7533\u8bf7" + applyId + "\u4e0d\u5b58\u5728");
        Map<String, Object> parameters = this.getBusinessTripParameters(businessTrip);
        String classResourcePath = (String)parameters.get("jrxml");
        URL resource = this.getClass().getResource(classResourcePath);
        if (resource == null) {
            this.logger.error("Can't found resource: " + classResourcePath);
            MyAssert.notNull(resource, "Can't found resource: " + classResourcePath);
        }
        this.logger.debug("read resource: " + resource.getFile());
        JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)new FileInputStream(resource.getFile()));
        return JasperRunManager.runReportToPdf((JasperReport)jasperReport, parameters, (JRDataSource)new JREmptyDataSource());
    }

    private Map<String, Object> getBusinessTripParameters(BusinessTripEntity businessTrip) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        Person person = this.personDao.queryPersonById(businessTrip.getTripUserId());
        root.put("jrxml", "/jrxml/businessTrip.jrxml");
        root.put("tripUserName", person.getName());
        root.put("position", StringUtils.isEmpty((CharSequence)businessTrip.getPosition()) ? "" : businessTrip.getPosition());
        String aAddStart = StringUtils.isEmpty((CharSequence)businessTrip.getaAddStart()) ? "" : businessTrip.getaAddStart();
        String aAddEnd = StringUtils.isEmpty((CharSequence)businessTrip.getaAddEnd()) ? "" : businessTrip.getaAddEnd();
        root.put("aAdd", StringUtils.isEmpty((CharSequence)aAddStart) ? "" : String.format("%s \u81f3 %s", aAddStart, aAddEnd));
        String bAddStart = StringUtils.isEmpty((CharSequence)businessTrip.getbAddStart()) ? "" : businessTrip.getbAddStart();
        String bAddEnd = StringUtils.isEmpty((CharSequence)businessTrip.getbAddEnd()) ? "" : businessTrip.getbAddEnd();
        root.put("bAdd", StringUtils.isEmpty((CharSequence)bAddStart) ? "" : String.format("%s \u81f3 %s", bAddStart, bAddEnd));
        root.put("reason", StringUtils.isEmpty((CharSequence)businessTrip.getReason()) ? "" : businessTrip.getReason());
        root.put("payUnit", StringUtils.isEmpty((CharSequence)businessTrip.getPayUnit()) ? "" : businessTrip.getPayUnit());
        Date sDate = businessTrip.getStartDate();
        Date eDate = businessTrip.getEndDate();
        root.put("tripDate", String.format("\u81ea%s\u6708%s\u65e5 \u81f3 %s\u6708%s\u65e5", DateFormatUtils.format((Date)sDate, (String)"M"), DateFormatUtils.format((Date)sDate, (String)"d"), DateFormatUtils.format((Date)eDate, (String)"M"), DateFormatUtils.format((Date)eDate, (String)"d")));
        root.put("trafficType", businessTrip.getTrafficType());
        List<FlowTraceEntity> flowTraces = this.flowTraceDao.getFlowTraceListByBusinessTypeAndId("business_trip", businessTrip.getApplyId());
        ArrayList mains = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(flowTraces)) {
            for (FlowTraceEntity flowTrace : flowTraces) {
                Date date = flowTrace.getCreateTime();
                String common = LakeMobUtils.isTrue(flowTrace.getPass()) ? "\u6279\u51c6" : "\u62d2\u7edd";
                String sign = "";
                ElectronicSignEntity electronicSign = this.electronicSignDao.getElectronicSignByPerson(flowTrace.getPersonId());
                if (null != electronicSign) {
                    sign = this.fastDFSClientService.getRealDownloadUrl(electronicSign.getSignUrl());
                }
                if (flowTrace.getTaskKey().equals("deptLeaderTask")) {
                    root.put("deptCommon", common);
                    root.put("deptSign", sign);
                    root.put("deptDate", DateFormatUtils.format((Date)date, (String)"yyyy \u5e74 MM \u6708 dd \u65e5"));
                    continue;
                }
                if (flowTrace.getTaskKey().equals("directLeaderTask")) {
                    root.put("directCommon", common);
                    root.put("directSign", sign);
                    root.put("directDate", DateFormatUtils.format((Date)date, (String)"yyyy \u5e74 MM \u6708 dd \u65e5"));
                    continue;
                }
                if (!flowTrace.getTaskKey().equals("mainLeaderTask")) continue;
                if (mains.size() == 1) {
                    root.put("main2Common", common);
                    root.put("main2Sign", sign);
                    root.put("main2Date", DateFormatUtils.format((Date)date, (String)"yyyy \u5e74 MM \u6708 dd \u65e5"));
                    root.put("jrxml", "/jrxml/businessTrip2main.jrxml");
                    continue;
                }
                mains.add(flowTrace);
                root.put("mainCommon", common);
                root.put("mainSign", sign);
                root.put("mainDate", DateFormatUtils.format((Date)date, (String)"yyyy \u5e74 MM \u6708 dd \u65e5"));
            }
        }
        return root;
    }

    private Map<String, Object> flowTrace2map(FlowTraceEntity flowTrace) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", flowTrace.getTraceId());
        map.put("personId", flowTrace.getPersonId());
        Person flowPerson = this.personDao.queryPersonById(flowTrace.getPersonId());
        map.put("personName", flowPerson.getName());
        if (null != flowTrace.getPass()) {
            map.put("statusDesc", flowTrace.getPass().equals("1") ? "\u6279\u51c6" : "\u62d2\u7edd");
        }
        map.put("createTime", Util.getDate((String)"yyyy/MM/dd HH:mm:ss", (Date)(null == flowTrace.getDoneTime() ? flowTrace.getCreateTime() : flowTrace.getDoneTime())));
        ElectronicSignEntity electronicSign = this.electronicSignDao.getElectronicSignByPerson(flowTrace.getPersonId());
        if (null != electronicSign) {
            map.put("electronicSignUrl", this.fastDFSClientService.getRealDownloadUrl(electronicSign.getSignUrl()));
        }
        return map;
    }

    private Map<String, Object> flowAssociate2Map(FlowAssociateEntity flowAssociate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", flowAssociate.getId());
        map.put("personId", flowAssociate.getPersonId());
        Person flowPerson = this.personDao.queryPersonById(flowAssociate.getPersonId());
        map.put("personName", flowPerson.getName());
        map.put("processed", LakeMobUtils.isTrue(flowAssociate.getProcessStatus()));
        return map;
    }

    @Override
    @Transactional(readOnly=false)
    public void applyBusinessTripReport(String applyId, BusinessTripInfo businessTripInfo) {
        BusinessTripEntity businessTripEntity = this.get(applyId);
        if (businessTripEntity != null) {
            try {
                if (!businessTripEntity.getTripUserId().equals(businessTripInfo.getTripUserId()) || businessTripEntity.getStatus() != BusinessTripStatusEnum.DONE.value) {
                    return;
                }
                businessTripEntity.setRealStartDate(Util.parseDate((String)businessTripInfo.getRealStartDateStr(), (String)"yyyy-MM-dd"));
                businessTripEntity.setRealEndDate(Util.parseDate((String)businessTripInfo.getRealEndDateStr(), (String)"yyyy-MM-dd"));
                businessTripEntity.setTripReason(businessTripInfo.getTripReason());
                businessTripEntity.setUpdateTime(new Date());
                businessTripEntity.setReportStatus("Y");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.businessTripDao.save(businessTripEntity);
            List<FlowTraceEntity> flowTraces = this.flowTraceDao.getFlowTraceListByBusinessTypeAndId("business_trip", applyId);
            if (!CollectionUtils.isEmpty(flowTraces)) {
                ArrayList<String> personIds = new ArrayList<String>();
                for (FlowTraceEntity flowTrace : flowTraces) {
                    if (flowTrace.getTaskKey().equals("revokeTask") || !"1".equals(flowTrace.getPass())) continue;
                    personIds.add(flowTrace.getPersonId());
                }
                String applyUserId = businessTripInfo.getTripUserId();
                Person applyPerson = this.personDao.queryPersonById(applyUserId);
                this.lakeMobPushService.pushBusinessTripApproval(personIds, applyPerson.getName() + "\u586b\u5199\u4e86\u51fa\u5dee\u62a5\u544a");
                for (String id : personIds) {
                    businessTripApplyNewStatusMap.put(id, true);
                }
            }
        }
    }

    @Override
    public int getBusinessTripDayCount(String personId, String dailyDate) {
        if (StringUtils.isEmpty((CharSequence)personId) || StringUtils.isEmpty((CharSequence)dailyDate)) {
            return 0;
        }
        return this.businessTripDao.getBusinessTripDayCount(personId, dailyDate);
    }

    @Override
    public List<BusinessTripEntity> businessTripList(Date begin, Date end, String personId, String reportStatus) {
        return this.businessTripDao.businessTripList(begin, end, personId, reportStatus);
    }

    @Override
    public List<BusinessTripDateBean> queryBusinessTripDateList(String personId, String startDate, String endDate) {
        return this.businessTripDao.queryBusinessTripDateList(personId, startDate, endDate);
    }
}

