/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.xdja.pams.bims.service.UserManageService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.xatl.ruyihu.dao.FlowTraceDao;
import pams.function.xatl.ruyihu.entity.FlowTraceEntity;
import pams.function.xatl.ruyihu.service.FlowTraceService;

@Service
public class FlowTraceServiceImpl
implements FlowTraceService {
    @Resource
    private UserManageService userManageService;
    @Resource
    private FlowTraceDao flowTraceDao;

    @Override
    @Transactional
    public void addFlowTrace(String businessType, String businessId, String workflowId, String taskId, String taskKey, String personId, String comment, String passStatus, Date createTime, Date doneTime) {
        FlowTraceEntity trace = new FlowTraceEntity();
        trace.setBusinessType(businessType);
        trace.setBusinessId(businessId);
        trace.setWorkflowId(workflowId);
        trace.setTaskId(taskId);
        trace.setTaskKey(taskKey);
        trace.setPersonId(personId);
        trace.setProcessComment(comment);
        trace.setPass(passStatus);
        trace.setCreateTime(createTime);
        trace.setDoneTime(doneTime);
        this.flowTraceDao.saveFlowTrace(trace);
    }

    @Override
    public List<FlowTraceEntity> getFlowTraceListByDocumentId(String documentId) {
        return this.flowTraceDao.getFlowTraceListByBusinessTypeAndId("document", documentId);
    }

    @Override
    public FlowTraceEntity getFlowTraceByBusinessAndTaskIdAndPerson(String businessId, String taskId, String personId) {
        return this.flowTraceDao.getFlowTraceByBusinessAndTaskIdAndPerson(businessId, taskId, personId);
    }

    @Override
    public List<FlowTraceEntity> getFlowTraceByBusinessAndTaskKey(String businessId, String taskKey) {
        return this.flowTraceDao.getFlowTraceByBusinessAndTaskKey(businessId, taskKey);
    }

    @Override
    public List<FlowTraceEntity> getFlowTraceListByLeaveId(String leaveId) {
        return this.flowTraceDao.getFlowTraceListByBusinessTypeAndId("leave", leaveId);
    }

    @Override
    public List<FlowTraceEntity> getFlowTraceListByBusiness(String businessType, String businessId) {
        return this.flowTraceDao.getFlowTraceListByBusinessTypeAndId(businessType, businessId);
    }
}

