/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.task.Task;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.xatl.ruyihu.bean.LeaveApprovalListNode;
import pams.function.xatl.ruyihu.bean.LeaveApprovalParam;
import pams.function.xatl.ruyihu.bean.LeaveDetail;
import pams.function.xatl.ruyihu.bean.LeaveDetailParam;
import pams.function.xatl.ruyihu.bean.LeaveListNode;
import pams.function.xatl.ruyihu.bean.LeaveListParam;
import pams.function.xatl.ruyihu.bean.LeaveSummaryInfo;
import pams.function.xatl.ruyihu.dao.IBusinessTripDao;
import pams.function.xatl.ruyihu.dao.LeaveDao;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.entity.BusinessTripEntity;
import pams.function.xatl.ruyihu.entity.CalendarEntity;
import pams.function.xatl.ruyihu.entity.ElectronicSignEntity;
import pams.function.xatl.ruyihu.entity.FlowAssociateEntity;
import pams.function.xatl.ruyihu.entity.FlowTraceEntity;
import pams.function.xatl.ruyihu.entity.LeaveEntity;
import pams.function.xatl.ruyihu.enums.HalfDayEnum;
import pams.function.xatl.ruyihu.enums.LeaveStatusEnum;
import pams.function.xatl.ruyihu.enums.LeaveTypeEnum;
import pams.function.xatl.ruyihu.service.AttachmentService;
import pams.function.xatl.ruyihu.service.CalendarService;
import pams.function.xatl.ruyihu.service.ElectronicSignService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.FlowAssociateService;
import pams.function.xatl.ruyihu.service.FlowTraceService;
import pams.function.xatl.ruyihu.service.LeaveQueryService;
import pams.function.xatl.ruyihu.service.impl.BusinessTripServiceImpl;
import pams.function.xatl.ruyihu.service.workflow.LakeMobWorkflowService;
import pams.function.xatl.ruyihu.util.LakeMobUtils;
import pams.function.xatl.ruyihu.util.QuickJson;

@Service
public class LeaveQueryServiceImpl
implements LeaveQueryService {
    @Resource
    private LeaveDao leaveDao;
    @Resource
    private FlowAssociateService flowAssociateService;
    @Resource
    private FlowTraceService flowTraceService;
    @Resource
    private ElectronicSignService electronicSignService;
    @Resource
    private LakeMobWorkflowService lakeMobWorkflowService;
    @Resource
    private UserManageService userManageService;
    @Resource
    private FastDFSClientService fastDFSClientService;
    @Resource
    private CalendarService calendarService;
    @Resource
    private AttachmentService attachmentService;
    @Resource
    private IBusinessTripDao businessTripDao;
    @Resource
    private RuntimeService runtimeService;
    private final Logger logger = LoggerFactory.getLogger(LeaveQueryServiceImpl.class);

    @Override
    public LeaveDetail getLeaveDetail(LeaveDetailParam leaveDetailParam) {
        Person person;
        LeaveEntity leaveEntity = this.leaveDao.getLeaveById(leaveDetailParam.getLeaveId());
        if (leaveEntity == null) {
            return null;
        }
        LeaveDetail leaveDetail = new LeaveDetail();
        BeanUtils.copyProperties((Object)leaveEntity, (Object)leaveDetail);
        leaveDetail.setType(leaveEntity.getLeaveType());
        leaveDetail.setTypeDesc(LeaveTypeEnum.getLeaveTypeDesc(leaveEntity.getLeaveType()));
        leaveDetail.setStatus(leaveEntity.getApprovalStatus());
        leaveDetail.setStatusDesc(LeaveStatusEnum.getLeaveStatusDesc(leaveEntity.getApprovalStatus()));
        leaveDetail.setCreateTimeStr(Util.getDate((String)"yyyy-MM-dd HH:mm", (Date)leaveEntity.getCreateTime()));
        if (leaveEntity.getPersonId().equals(leaveDetailParam.getUserId())) {
            BusinessTripServiceImpl.leaveApproveListNewStatusMap.put(leaveDetailParam.getLeaveId(), false);
        }
        if ((person = this.userManageService.queryPersonById(leaveEntity.getPersonId())) != null) {
            leaveDetail.setPersonName(person.getName());
        }
        leaveDetail.setLeaveBeginTime(Util.getDate((String)"yyyy/MM/dd", (Date)leaveEntity.getBeginDate()) + " " + HalfDayEnum.getHalfDayName(leaveEntity.getBeginHalfDay()));
        leaveDetail.setLeaveEndTime(Util.getDate((String)"yyyy/MM/dd", (Date)leaveEntity.getEndDate()) + " " + HalfDayEnum.getHalfDayName(leaveEntity.getEndHalfDay()));
        leaveDetail.setCellLeaderName(LakeMobUtils.getLeaveCellLeaderName(leaveEntity.getCellLeaderId(), this.userManageService));
        leaveDetail.setRealStartTime(Util.getDate((String)"yyyy/MM/dd", (Date)leaveEntity.getRealStartDate()) + " " + HalfDayEnum.getHalfDayName(leaveEntity.getRealStartHalfDay()));
        leaveDetail.setRealEndTime(Util.getDate((String)"yyyy/MM/dd", (Date)leaveEntity.getRealEndDate()) + " " + HalfDayEnum.getHalfDayName(leaveEntity.getRealEndHalfDay()));
        leaveDetail.setRealDayCount(leaveEntity.getRealDayCount());
        if (leaveEntity.getCancelStatus() != null && leaveEntity.getCancelStatus().equals("Y")) {
            leaveDetail.setCancelStatus("Y");
        } else {
            leaveDetail.setCancelStatus("N");
        }
        List<AttachmentEntity> attachments = this.attachmentService.getAttachmentListByOwnerId(leaveDetailParam.getLeaveId(), "leave");
        ArrayNode attachmentListNode = QuickJson.newArrayNode();
        for (AttachmentEntity attachmentEntity : attachments) {
            attachmentListNode.add((JsonNode)QuickJson.newObjectNode().put("id", attachmentEntity.getAttachmentId()).put("name", attachmentEntity.getAttachmentName()).put("size", attachmentEntity.getAttachmentSize()).put("url", this.fastDFSClientService.getRealDownloadUrl(attachmentEntity.getAttachmentUrl())));
        }
        leaveDetail.setAttachmentList(attachmentListNode);
        List<FlowAssociateEntity> flowAssociateList = this.flowAssociateService.getFlowAssociateListByLeaveId(leaveDetailParam.getLeaveId());
        if (flowAssociateList == null) {
            flowAssociateList = new ArrayList<FlowAssociateEntity>();
        }
        for (FlowAssociateEntity flowAssociateEntity : flowAssociateList) {
            LeaveDetail.WorkflowPerson workflowPerson = leaveDetail.new LeaveDetail.WorkflowPerson();
            workflowPerson.setId(flowAssociateEntity.getId());
            workflowPerson.setPersonId(flowAssociateEntity.getPersonId());
            if (flowAssociateEntity.getPersonId().equals(leaveDetailParam.getUserId())) {
                workflowPerson.setPersonName("\u6211");
            } else {
                Person flowPerson = this.userManageService.queryPersonById(flowAssociateEntity.getPersonId());
                if (flowPerson != null) {
                    workflowPerson.setPersonName(flowPerson.getName());
                }
            }
            if ("1".equals(flowAssociateEntity.getProcessStatus())) {
                workflowPerson.setProcessed(true);
            } else {
                workflowPerson.setProcessed(false);
            }
            leaveDetail.getWorkflowPersonList().add(workflowPerson);
        }
        LeaveDetail.WorkflowTrace workflowTrace = leaveDetail.new LeaveDetail.WorkflowTrace();
        workflowTrace.setId("0");
        workflowTrace.setFlag(1);
        workflowTrace.setPersonId(leaveDetail.getPersonId());
        workflowTrace.setPersonName(leaveDetail.getPersonName());
        workflowTrace.setStatusDesc(null);
        workflowTrace.setCreateTime(Util.getDate((String)"yyyy/MM/dd HH:mm:ss", (Date)leaveEntity.getCreateTime()));
        ElectronicSignEntity electronicSignEntity = this.electronicSignService.getElectronicSignByPerson(leaveDetail.getPersonId());
        if (electronicSignEntity != null) {
            workflowTrace.setElectronicSignUrl(this.fastDFSClientService.getRealDownloadUrl(electronicSignEntity.getSignUrl()));
        }
        leaveDetail.getWorkflowTraceList().add(workflowTrace);
        if (leaveDetail.getStatus().equals(LeaveStatusEnum.LEAVE_APPROVAL_REVOKE.getStatus())) {
            LeaveDetail.WorkflowTrace revokeWorkflowTrace = leaveDetail.new LeaveDetail.WorkflowTrace();
            revokeWorkflowTrace.setId("0");
            revokeWorkflowTrace.setFlag(2);
            revokeWorkflowTrace.setPersonId(leaveDetail.getPersonId());
            revokeWorkflowTrace.setPersonName(leaveDetail.getPersonName());
            revokeWorkflowTrace.setStatusDesc(null);
            revokeWorkflowTrace.setCreateTime(Util.getDate((String)"yyyy/MM/dd HH:mm:ss", (Date)leaveEntity.getDoneTime()));
            revokeWorkflowTrace.setElectronicSignUrl(workflowTrace.getElectronicSignUrl());
            leaveDetail.getWorkflowTraceList().add(revokeWorkflowTrace);
            leaveDetail.setWorkflowBeginTime(revokeWorkflowTrace.getCreateTime());
            leaveDetail.setWorkflowEndTime(revokeWorkflowTrace.getCreateTime());
            leaveDetail.setCanRevoke(false);
            return leaveDetail;
        }
        List<FlowTraceEntity> flowTraceList = this.flowTraceService.getFlowTraceListByLeaveId(leaveDetailParam.getLeaveId());
        if (flowTraceList == null) {
            flowTraceList = new ArrayList<FlowTraceEntity>();
        }
        for (FlowTraceEntity flowTraceEntity : flowTraceList) {
            LeaveDetail.WorkflowTrace workflowTrace2 = leaveDetail.new LeaveDetail.WorkflowTrace();
            workflowTrace2.setId(flowTraceEntity.getTraceId());
            workflowTrace2.setFlag(0);
            workflowTrace2.setPersonId(flowTraceEntity.getPersonId());
            Person tracePerson = this.userManageService.queryPersonById(flowTraceEntity.getPersonId());
            if (tracePerson != null) {
                workflowTrace2.setPersonName(tracePerson.getName());
            }
            if ("1".equals(flowTraceEntity.getPass())) {
                workflowTrace2.setStatusDesc("\u901a\u8fc7");
            } else if ("3".equals(flowTraceEntity.getPass())) {
                workflowTrace2.setStatusDesc("\u5df2\u9500\u5047");
                workflowTrace2.setFlag(3);
            } else {
                workflowTrace2.setStatusDesc("\u672a\u901a\u8fc7");
            }
            workflowTrace2.setCreateTime(Util.getDate((String)"yyyy/MM/dd HH:mm:ss", (Date)flowTraceEntity.getDoneTime()));
            ElectronicSignEntity traceElectronicSignEntity = this.electronicSignService.getElectronicSignByPerson(flowTraceEntity.getPersonId());
            if (traceElectronicSignEntity != null) {
                workflowTrace2.setElectronicSignUrl(this.fastDFSClientService.getRealDownloadUrl(traceElectronicSignEntity.getSignUrl()));
            }
            leaveDetail.getWorkflowTraceList().add(workflowTrace2);
        }
        if (flowTraceList.size() > 0) {
            leaveDetail.setWorkflowBeginTime(Util.getDate((String)"yyyy/MM/dd HH:mm:ss", (Date)leaveEntity.getCreateTime()));
            leaveDetail.setWorkflowEndTime(Util.getDate((String)"yyyy/MM/dd HH:mm:ss", (Date)leaveEntity.getDoneTime()));
            leaveDetail.setCanRevoke(false);
        } else {
            leaveDetail.setCanRevoke(true);
        }
        return leaveDetail;
    }

    @Override
    public List<LeaveListNode> getLeaveList(LeaveListParam leaveListParam, int pageSize) throws Exception {
        List<LeaveEntity> leaveEntityList = this.leaveDao.getLeaveList(leaveListParam, pageSize);
        ArrayList<LeaveListNode> leaveListNodeList = new ArrayList<LeaveListNode>();
        if (leaveEntityList == null) {
            leaveListParam.setTimestamp(0L);
            return leaveListNodeList;
        }
        for (LeaveEntity leaveEntity : leaveEntityList) {
            LeaveListNode leaveListNode = new LeaveListNode();
            leaveListNode.setLeaveId(leaveEntity.getLeaveId());
            leaveListNode.setPersonId(leaveEntity.getPersonId());
            Person person = this.userManageService.queryPersonById(leaveEntity.getPersonId());
            if (person != null) {
                leaveListNode.setPersonName(person.getName());
            }
            leaveListNode.setType(leaveEntity.getLeaveType());
            leaveListNode.setTypeDesc(LeaveTypeEnum.getLeaveTypeDesc(leaveEntity.getLeaveType()));
            leaveListNode.setStatus(leaveEntity.getApprovalStatus());
            leaveListNode.setStatusDesc(LeaveStatusEnum.getLeaveStatusDesc(leaveEntity.getApprovalStatus()));
            leaveListNode.setLeaveBeginTime(Util.getDate((String)"yyyy/MM/dd", (Date)leaveEntity.getBeginDate()) + " " + HalfDayEnum.getHalfDayName(leaveEntity.getBeginHalfDay()));
            leaveListNode.setLeaveEndTime(Util.getDate((String)"yyyy/MM/dd", (Date)leaveEntity.getEndDate()) + " " + HalfDayEnum.getHalfDayName(leaveEntity.getEndHalfDay()));
            leaveListNode.setCreateTimeStr(Util.getDate((String)"yyyy-MM-dd HH:mm", (Date)leaveEntity.getCreateTime()));
            boolean isNew = BusinessTripServiceImpl.leaveApproveListNewStatusMap.containsKey(leaveListNode.getLeaveId()) ? BusinessTripServiceImpl.leaveApproveListNewStatusMap.get(leaveListNode.getLeaveId()) : false;
            leaveListNode.setNewStatus(isNew);
            leaveListNodeList.add(leaveListNode);
        }
        if (leaveEntityList.size() > 0) {
            leaveListParam.setTimestamp(leaveEntityList.get(leaveEntityList.size() - 1).getCreateTime().getTime());
        } else {
            leaveListParam.setTimestamp(0L);
        }
        return leaveListNodeList;
    }

    @Override
    public int countLeaveList(LeaveListParam leaveListParam) throws Exception {
        return this.leaveDao.countLeaveList(leaveListParam);
    }

    @Override
    public List<LeaveApprovalListNode> getPendingLeaveApprovalList(LeaveApprovalParam leaveApprovalParam, int pageSize) {
        List<Task> taskList = this.lakeMobWorkflowService.getTopPendingLeaveApprovalList(leaveApprovalParam, pageSize);
        if (taskList == null) {
            taskList = new ArrayList<Task>();
        }
        ArrayList<String> leaveIdList = new ArrayList<String>();
        HashMap<String, String> leaveTaskMap = new HashMap<String, String>();
        for (Task task : taskList) {
            String businessKey = this.lakeMobWorkflowService.getBusinessKey(task);
            leaveIdList.add(businessKey);
            leaveTaskMap.put(businessKey, task.getId());
        }
        List<LeaveEntity> leaveEntityList = this.leaveDao.getLeaveListByIds(leaveIdList, pageSize);
        if (leaveIdList.size() != leaveEntityList.size()) {
            this.logger.warn("\u67e5\u51fa\u7684\u8bf7\u5047\u5916\u51fa\u7533\u8bf7\u6570\u91cf\u4e0e\u5de5\u4f5c\u6d41\u5f15\u64ce\u4e2d\u5f85\u5ba1\u6279\u6570\u91cf\u4e0d\u4e00\u81f4, " + leaveEntityList.size() + "<>" + leaveIdList.size());
        }
        ArrayList<LeaveApprovalListNode> leaveApprovalListNodeList = new ArrayList<LeaveApprovalListNode>();
        for (LeaveEntity leaveEntity : leaveEntityList) {
            LeaveApprovalListNode leaveApprovalListNode = new LeaveApprovalListNode();
            leaveApprovalListNode.setTaskId((String)leaveTaskMap.get(leaveEntity.getLeaveId()));
            leaveApprovalListNode.setCreateTime(Util.getDate((String)"yyyy/MM/dd HH:mm:ss", (Date)leaveEntity.getCreateTime()));
            leaveApprovalListNode.setLeaveId(leaveEntity.getLeaveId());
            leaveApprovalListNode.setType(leaveEntity.getLeaveType());
            leaveApprovalListNode.setTypeDesc(LeaveTypeEnum.getLeaveTypeDesc(leaveEntity.getLeaveType()));
            leaveApprovalListNode.setStatus(leaveEntity.getApprovalStatus());
            leaveApprovalListNode.setStatusDesc(LeaveStatusEnum.getLeaveStatusDesc(leaveEntity.getApprovalStatus()));
            leaveApprovalListNode.setLeaveBeginTime(Util.getDate((String)"yyyy/MM/dd", (Date)leaveEntity.getBeginDate()) + " " + HalfDayEnum.getHalfDayName(leaveEntity.getBeginHalfDay()));
            leaveApprovalListNode.setLeaveEndTime(Util.getDate((String)"yyyy/MM/dd", (Date)leaveEntity.getEndDate()) + " " + HalfDayEnum.getHalfDayName(leaveEntity.getEndHalfDay()));
            leaveApprovalListNode.setCreateTimeStr(Util.getDate((String)"yyyy-MM-dd HH:mm", (Date)leaveEntity.getCreateTime()));
            leaveApprovalListNode.setPersonId(leaveEntity.getPersonId());
            Person person = this.userManageService.queryPersonById(leaveEntity.getPersonId());
            if (person != null) {
                leaveApprovalListNode.setPersonName(person.getName());
            }
            leaveApprovalListNode.setDayCount(Float.valueOf(leaveEntity.getDayCount()));
            boolean isNew = BusinessTripServiceImpl.leaveApplyListNewStatusMap.containsKey(leaveApprovalListNode.getLeaveId()) ? BusinessTripServiceImpl.leaveApplyListNewStatusMap.get(leaveApprovalListNode.getLeaveId()) : false;
            leaveApprovalListNode.setNewStatus(isNew);
            leaveApprovalListNodeList.add(leaveApprovalListNode);
        }
        if (leaveEntityList.size() > 0) {
            leaveApprovalParam.setTimestamp(leaveEntityList.get(leaveEntityList.size() - 1).getCreateTime().getTime());
        } else {
            leaveApprovalParam.setTimestamp(0L);
        }
        return leaveApprovalListNodeList;
    }

    @Override
    public int countLeaveListByIds(List<String> leaveIdList, Long timestamp) {
        return this.leaveDao.countLeaveListByIds(leaveIdList);
    }

    @Override
    public List<LeaveListNode> getLeaveListWithApproval(LeaveListParam leaveListParam, int pageSize) throws Exception {
        List<LeaveEntity> leaveEntityList = this.leaveDao.getLeaveListWithApproval(leaveListParam, pageSize);
        ArrayList<LeaveListNode> leaveListNodeList = new ArrayList<LeaveListNode>();
        if (leaveEntityList == null) {
            leaveListParam.setTimestamp(0L);
            return leaveListNodeList;
        }
        for (LeaveEntity leaveEntity : leaveEntityList) {
            LeaveListNode leaveListNode = new LeaveListNode();
            leaveListNode.setLeaveId(leaveEntity.getLeaveId());
            leaveListNode.setPersonId(leaveEntity.getPersonId());
            Person person = this.userManageService.queryPersonById(leaveEntity.getPersonId());
            if (person != null) {
                leaveListNode.setPersonName(person.getName());
            }
            leaveListNode.setType(leaveEntity.getLeaveType());
            leaveListNode.setTypeDesc(LeaveTypeEnum.getLeaveTypeDesc(leaveEntity.getLeaveType()));
            leaveListNode.setStatus(leaveEntity.getApprovalStatus());
            leaveListNode.setStatusDesc(LeaveStatusEnum.getLeaveStatusDesc(leaveEntity.getApprovalStatus()));
            leaveListNode.setLeaveBeginTime(Util.getDate((String)"yyyy/MM/dd", (Date)leaveEntity.getBeginDate()) + " " + HalfDayEnum.getHalfDayName(leaveEntity.getBeginHalfDay()));
            leaveListNode.setLeaveEndTime(Util.getDate((String)"yyyy/MM/dd", (Date)leaveEntity.getEndDate()) + " " + HalfDayEnum.getHalfDayName(leaveEntity.getEndHalfDay()));
            leaveListNode.setCreateTimeStr(Util.getDate((String)"yyyy-MM-dd HH:mm", (Date)leaveEntity.getCreateTime()));
            leaveListNodeList.add(leaveListNode);
        }
        if (leaveEntityList.size() > 0) {
            leaveListParam.setTimestamp(leaveEntityList.get(leaveEntityList.size() - 1).getCreateTime().getTime());
        } else {
            leaveListParam.setTimestamp(0L);
        }
        return leaveListNodeList;
    }

    @Override
    public int countLeaveListWithApproval(LeaveListParam leaveListParam) throws Exception {
        return this.leaveDao.countLeaveListWithApproval(leaveListParam);
    }

    @Override
    public List<LeaveEntity> getLeaveList(Date begin, Date end, String personNameLike, String type, String status, Page pageParam) {
        return this.leaveDao.getLeaveList(begin, end, personNameLike, type, status, pageParam);
    }

    @Override
    public LeaveEntity getLeaveById(String leaveId) {
        return this.leaveDao.getLeaveById(leaveId);
    }

    @Override
    public List<LeaveSummaryInfo> getLeaveSummaryList(Date begin, Date end, String controlDeps, String controlPolices, String personNameLike, String depNameLike, Page pageParam) {
        QueryPersonBean queryBean = new QueryPersonBean();
        queryBean.setName(personNameLike);
        queryBean.setDepName(depNameLike);
        queryBean.setIsContain("false");
        List personList = this.userManageService.queryPersonList(queryBean, controlDeps, controlPolices, pageParam);
        ArrayList rst = Lists.newArrayList();
        for (Person one : personList) {
            LeaveSummaryInfo sum = new LeaveSummaryInfo();
            sum.setPersonId(one.getId());
            sum.setPersonName(one.getName());
            sum.setDepId(one.getDepartment().getId());
            sum.setDepName(one.getDepartment().getName());
            List<LeaveEntity> officialLeaveEntityList = this.leaveDao.getLeaveList(one.getId(), begin, end, "leave_type_official", null);
            sum.setTotalOfficial(this.getLeaveDays(begin, end, officialLeaveEntityList));
            List<LeaveEntity> affairLeaveEntityList = this.leaveDao.getLeaveList(one.getId(), begin, end, "leave_type_affair", null);
            sum.setTotalAffair(this.getLeaveDays(begin, end, affairLeaveEntityList));
            List<LeaveEntity> sickLeaveEntityList = this.leaveDao.getLeaveList(one.getId(), begin, end, "leave_type_sick", null);
            sum.setTotalSick(this.getLeaveDays(begin, end, sickLeaveEntityList));
            List<LeaveEntity> holidayLeaveEntityList = this.leaveDao.getLeaveList(one.getId(), begin, end, "leave_type_holiday", null);
            sum.setTotalHoliday(this.getLeaveDays(begin, end, holidayLeaveEntityList));
            List<LeaveEntity> otherLeaveEntityList = this.leaveDao.getLeaveList(one.getId(), begin, end, "leave_type_other", null);
            sum.setTotalOther(this.getLeaveDays(begin, end, otherLeaveEntityList));
            List<LeaveEntity> allLeaveEntityList = this.leaveDao.getLeaveListNotType(one.getId(), begin, end, "leave_type_official");
            sum.setTotalLeave(this.getLeaveDays(begin, end, allLeaveEntityList));
            List<LeaveEntity> maritalLeaveEntityList = this.leaveDao.getLeaveList(one.getId(), begin, end, "leave_type_marital", null);
            sum.setTotalMarital(this.getLeaveDays(begin, end, maritalLeaveEntityList));
            List<BusinessTripEntity> businessTripEntities = this.businessTripDao.myList(one.getId());
            sum.setTotalBusinessTrip(this.getBusinessDays(begin, end, businessTripEntities));
            rst.add(sum);
        }
        return rst;
    }

    @Override
    public float getLeaveDays(Date beginDate, Date endDate, List<LeaveEntity> leaveEntityList) {
        if (leaveEntityList == null || leaveEntityList.size() == 0) {
            return 0.0f;
        }
        List<CalendarEntity> calendarEntityList = this.calendarService.queryCalendarEntityList(beginDate, endDate);
        float leaveDays = 0.0f;
        for (LeaveEntity leaveEntity : leaveEntityList) {
            Date beginDateTemp = null;
            int beginHalfDayTemp = 0;
            Date endDateTemp = null;
            int endHalfDayTemp = 0;
            if (StringUtils.isNotEmpty((String)leaveEntity.getCancelStatus()) && leaveEntity.getCancelStatus().equals("Y")) {
                beginDateTemp = leaveEntity.getRealStartDate();
                beginHalfDayTemp = leaveEntity.getRealStartHalfDay();
                endDateTemp = leaveEntity.getRealEndDate();
                endHalfDayTemp = leaveEntity.getRealEndHalfDay();
            } else {
                beginDateTemp = leaveEntity.getBeginDate();
                beginHalfDayTemp = leaveEntity.getBeginHalfDay();
                endDateTemp = leaveEntity.getEndDate();
                endHalfDayTemp = leaveEntity.getEndHalfDay();
            }
            if (beginDateTemp.getTime() < beginDate.getTime()) {
                beginDateTemp = beginDate;
                beginHalfDayTemp = 1;
            }
            if (endDateTemp.getTime() > endDate.getTime()) {
                endDateTemp = endDate;
                endHalfDayTemp = 2;
            }
            leaveDays += this.getLeaveDays(beginDateTemp, beginHalfDayTemp, endDateTemp, endHalfDayTemp, calendarEntityList, leaveEntity.getLeaveType());
        }
        return leaveDays;
    }

    @Override
    public float getLeaveDays(Date beginDate, int beginHalfDay, Date endDate, int endHalfDay, List<CalendarEntity> calendarEntityList, String type) {
        if (endDate.getTime() < beginDate.getTime() || endDate == beginDate && endHalfDay < beginHalfDay) {
            this.logger.error("\u7ed3\u675f\u65e5\u671f\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f");
            return 0.0f;
        }
        float leaveDays = this.calendarService.getIntervalDays(beginDate, endDate) + 1;
        if (beginHalfDay == 2 && !this.calendarService.isRestDay(beginDate, calendarEntityList, type)) {
            leaveDays -= 0.5f;
        }
        if (endHalfDay == 1 && !this.calendarService.isRestDay(endDate, calendarEntityList, type)) {
            leaveDays -= 0.5f;
        }
        Date date = beginDate;
        while (date.getTime() <= endDate.getTime() && leaveDays > 0.0f) {
            if (this.calendarService.isRestDay(date, calendarEntityList, type)) {
                leaveDays -= 1.0f;
            }
            date = this.calendarService.addOneday(date);
        }
        if (leaveDays <= 0.0f) {
            leaveDays = 0.0f;
        }
        return leaveDays;
    }

    @Override
    @Transactional
    public void delete(String leaveId) {
        LeaveEntity leave = this.leaveDao.getLeaveById(leaveId);
        this.leaveDao.delete(leave);
        this.lakeMobWorkflowService.delete(leaveId, "lakemob_leave");
    }

    private float getBusinessDays(Date beginDate, Date stopDate, List<BusinessTripEntity> businessTripEntities) {
        if (businessTripEntities == null || businessTripEntities.size() == 0) {
            return 0.0f;
        }
        float businessDays = 0.0f;
        try {
            for (BusinessTripEntity businessTrip : businessTripEntities) {
                Date startDate = businessTrip.getStartDate();
                Date endDate = businessTrip.getEndDate();
                if (beginDate.getTime() > startDate.getTime()) {
                    startDate = beginDate;
                }
                if (stopDate.getTime() < endDate.getTime()) {
                    endDate = stopDate;
                }
                businessDays += (float)(this.calendarService.getIntervalDays(startDate, endDate) + 1);
            }
        }
        catch (Exception e) {
            this.logger.error("\u7edf\u8ba1\u51fa\u9519", (Throwable)e);
            return businessDays;
        }
        return businessDays;
    }

    @Override
    public float getLeaveDaysForPerson(Date begin, Date end, String personId) {
        float leaveDays = 0.0f;
        List<LeaveEntity> officialLeaveEntityList = this.leaveDao.getLeaveList(personId, begin, end, null, null);
        leaveDays = this.getLeaveDays(begin, end, officialLeaveEntityList);
        return leaveDays;
    }

    @Override
    public List<LeaveEntity> getLeaveList(String personId, Date begin, Date end, String leaveType, String cancelStatus) {
        return this.leaveDao.getLeaveList(personId, begin, end, leaveType, cancelStatus);
    }
}

