/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.tims.service.MsgPushService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.xatl.ruyihu.bean.ApplyLeaveInfo;
import pams.function.xatl.ruyihu.bean.LeaveDetailParam;
import pams.function.xatl.ruyihu.dao.AttachmentDao;
import pams.function.xatl.ruyihu.dao.FlowAssociateDao;
import pams.function.xatl.ruyihu.dao.FlowTraceDao;
import pams.function.xatl.ruyihu.dao.LeaveDao;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.entity.FlowAssociateEntity;
import pams.function.xatl.ruyihu.entity.FlowTraceEntity;
import pams.function.xatl.ruyihu.entity.LeaveEntity;
import pams.function.xatl.ruyihu.enums.LeaveTypeEnum;
import pams.function.xatl.ruyihu.service.AuthService;
import pams.function.xatl.ruyihu.service.FlowTraceService;
import pams.function.xatl.ruyihu.service.LakeMobPushService;
import pams.function.xatl.ruyihu.service.LeaveService;
import pams.function.xatl.ruyihu.service.workflow.LakeMobWorkflowService;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.ruyihu.util.LakeMobUtils;

@Service
public class LeaveServiceImpl
implements LeaveService {
    @Resource
    private UserManageService userManageService;
    @Resource
    private AuthService authService;
    @Resource
    private FlowTraceService flowTraceService;
    @Resource
    private LakeMobWorkflowService lakeMobWorkflowService;
    @Resource
    private MsgPushService msgPushService;
    @Resource
    private LeaveDao leaveDao;
    @Resource
    private FlowAssociateDao flowAssociateDao;
    @Resource
    private FlowTraceDao flowTraceDao;
    @Resource
    private LakeMobPushService lakeMobPushService;
    @Resource
    private AttachmentDao attachmentDao;
    public static final Logger LOGGER = LoggerFactory.getLogger(LeaveServiceImpl.class);

    @Override
    @Transactional
    public void doneLeave(String leaveId, boolean revoked, boolean pass) {
        LeaveEntity leave = this.leaveDao.getLeaveById(leaveId);
        if (leave != null) {
            if (revoked) {
                leave.setApprovalStatus("leave_approval_revoke");
            } else if (!pass) {
                leave.setApprovalStatus("leave_approval_reject");
            } else {
                leave.setApprovalStatus("leave_approval_pass");
            }
            leave.setDoneTime(LakeMobUtils.now());
            this.leaveDao.saveLeave(leave);
            if (!revoked) {
                this.lakeMobPushService.pushLeaveEnd(Arrays.asList(leave.getPersonId()));
            }
        }
    }

    @Override
    @Transactional
    public String applyLeave(ApplyLeaveInfo applyLeaveInfo, List<AttachmentEntity> attachmentEntities) {
        Date date = new Date();
        Person person = this.userManageService.queryPersonById(applyLeaveInfo.getUserId());
        if (person == null) {
            throw new LakeMobException("\u7cfb\u7edf\u5185\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u4eba\u5458");
        }
        LeaveEntity leaveEntity = new LeaveEntity();
        leaveEntity.setApprovalStatus("leave_approval_ing");
        try {
            leaveEntity.setBeginDate(Util.parseDate((String)applyLeaveInfo.getBeginDate(), (String)"yyyy-MM-dd"));
            leaveEntity.setEndDate(Util.parseDate((String)applyLeaveInfo.getEndTime(), (String)"yyyy-MM-dd"));
        }
        catch (Exception e) {
            LOGGER.error("\u5f00\u59cb\u6216\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u4e0d\u5bf9");
            throw new LakeMobException("\u5f00\u59cb\u6216\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u4e0d\u5bf9");
        }
        leaveEntity.setBeginHalfDay(applyLeaveInfo.getBeginHalfDay());
        leaveEntity.setEndHalfDay(applyLeaveInfo.getEndHalfDay());
        leaveEntity.setCellLeaderId(applyLeaveInfo.getCellLeaderId());
        leaveEntity.setCreateTime(date);
        leaveEntity.setDayCount(applyLeaveInfo.getDayCount().floatValue());
        leaveEntity.setDepId(person.getDepId());
        leaveEntity.setJoinDate(applyLeaveInfo.getJoinDate());
        leaveEntity.setLeaveType(applyLeaveInfo.getType());
        leaveEntity.setPersonId(applyLeaveInfo.getUserId());
        leaveEntity.setReason(applyLeaveInfo.getReason());
        leaveEntity.setCancelStatus("N");
        this.leaveDao.saveLeave(leaveEntity);
        for (AttachmentEntity one : attachmentEntities) {
            one.setOwnerId(leaveEntity.getLeaveId());
            this.attachmentDao.saveAttachment(one);
        }
        for (int i = 0; i < applyLeaveInfo.getWorkflowPersonList().size(); ++i) {
            FlowAssociateEntity flowAssociateEntity = new FlowAssociateEntity();
            flowAssociateEntity.setBusinessId(leaveEntity.getLeaveId());
            flowAssociateEntity.setBusinessType("leave");
            flowAssociateEntity.setCreateTime(date);
            flowAssociateEntity.setDoneTime(null);
            flowAssociateEntity.setOrderNum(i + 1);
            flowAssociateEntity.setPersonId(applyLeaveInfo.getWorkflowPersonList().get(i));
            flowAssociateEntity.setProcessStatus("0");
            flowAssociateEntity.setTaskKey("leaveApprovalTask");
            this.flowAssociateDao.saveFlowAssociate(flowAssociateEntity);
        }
        String workflowId = this.lakeMobWorkflowService.startLeaveWorkflow(leaveEntity.getLeaveId(), person.getId(), applyLeaveInfo.getWorkflowPersonList());
        leaveEntity.setWorkflowId(workflowId);
        this.leaveDao.saveLeave(leaveEntity);
        return leaveEntity.getLeaveId();
    }

    private void checkOfficeLeader(ApplyLeaveInfo applyLeaveInfo) {
        if (applyLeaveInfo.getType().equals(LeaveTypeEnum.LEAVE_TYEP_HOLIDAY.getType())) {
            String officeLeader = this.authService.getOfficeLeader();
            if (!applyLeaveInfo.getWorkflowPersonList().contains(officeLeader)) {
                applyLeaveInfo.getWorkflowPersonList().add(0, officeLeader);
            }
        }
    }

    private void checkAndAddOfficeLeader(ApplyLeaveInfo applyLeaveInfo) {
        String officeLeader = this.authService.getOfficeLeader();
        if (applyLeaveInfo.getWorkflowPersonList() == null) {
            applyLeaveInfo.setWorkflowPersonList(new ArrayList<String>());
        }
        applyLeaveInfo.getWorkflowPersonList().add(officeLeader);
        ArrayList<String> uniqueWorkflowPersonList = new ArrayList<String>();
        for (String wokrflowPerson : applyLeaveInfo.getWorkflowPersonList()) {
            if (uniqueWorkflowPersonList.contains(wokrflowPerson)) continue;
            uniqueWorkflowPersonList.add(wokrflowPerson);
        }
        applyLeaveInfo.setWorkflowPersonList(uniqueWorkflowPersonList);
    }

    @Override
    @Transactional
    public boolean revokeLeave(LeaveDetailParam leaveDetailParam) {
        LeaveEntity leaveEntity = this.leaveDao.getLeaveById(leaveDetailParam.getLeaveId());
        if (leaveEntity == null) {
            LOGGER.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8bf7\u5047\u5916\u51fa\u3002leaveId:" + leaveDetailParam.getLeaveId());
            throw new LakeMobException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8bf7\u5047\u5916\u51fa");
        }
        if (!leaveEntity.getPersonId().equals(leaveDetailParam.getUserId())) {
            LOGGER.info("\u8bf7\u5047\u5916\u51fa\u975e\u672c\u4eba\u4e0d\u80fd\u64a4\u9500\u3002leaveId:" + leaveDetailParam.getLeaveId() + "\uff0cuserId:" + leaveDetailParam.getUserId());
            throw new LakeMobException("\u8bf7\u5047\u5916\u51fa\u975e\u672c\u4eba\u4e0d\u80fd\u64a4\u9500");
        }
        List<FlowTraceEntity> flowTraceEntityList = this.flowTraceService.getFlowTraceListByLeaveId(leaveDetailParam.getLeaveId());
        if (flowTraceEntityList != null && flowTraceEntityList.size() > 0) {
            return false;
        }
        return this.lakeMobWorkflowService.revokeLeave(leaveDetailParam.getUserId(), leaveDetailParam.getLeaveId());
    }

    @Override
    @Transactional
    public boolean cancelLeave(LeaveDetailParam leaveDetailParam) {
        boolean result = true;
        LeaveEntity leaveEntity = this.leaveDao.getLeaveById(leaveDetailParam.getLeaveId());
        if (leaveEntity == null) {
            LOGGER.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8bf7\u5047\u5916\u51fa\u3002leaveId:" + leaveDetailParam.getLeaveId());
            throw new LakeMobException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8bf7\u5047\u5916\u51fa");
        }
        if (!leaveEntity.getPersonId().equals(leaveDetailParam.getUserId())) {
            LOGGER.info("\u8bf7\u5047\u5916\u51fa\u975e\u672c\u4eba\u4e0d\u80fd\u9500\u5047\u3002leaveId:" + leaveDetailParam.getLeaveId() + "\uff0cuserId:" + leaveDetailParam.getUserId());
            throw new LakeMobException("\u8bf7\u5047\u5916\u51fa\u975e\u672c\u4eba\u4e0d\u80fd\u9500\u5047");
        }
        try {
            leaveEntity.setRealStartDate(Util.parseDate((String)leaveDetailParam.getRealStartDate(), (String)"yyyy-MM-dd"));
            leaveEntity.setRealEndDate(Util.parseDate((String)leaveDetailParam.getRealEndDate(), (String)"yyyy-MM-dd"));
            leaveEntity.setRealStartHalfDay(leaveDetailParam.getRealStartHalfDay());
            leaveEntity.setRealEndHalfDay(leaveDetailParam.getRealEndHalfDay());
            leaveEntity.setRealDayCount(leaveDetailParam.getRealDayCount());
            leaveEntity.setCancelStatus("Y");
            this.leaveDao.updateLeave(leaveEntity);
            this.flowTraceService.addFlowTrace("leave", leaveEntity.getLeaveId(), leaveEntity.getWorkflowId(), System.currentTimeMillis() + "", "leaveApprovalTask", leaveEntity.getPersonId(), "\u5df2\u9500\u5047", "3", LakeMobUtils.now(), LakeMobUtils.now());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            result = false;
        }
        return result;
    }
}

