/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.util;

import com.google.common.base.Throwables;
import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.util.StringUtils;

public class FreeworkDateEditor
extends PropertyEditorSupport {
    public static final FreeworkDateEditor INSTANCE = new FreeworkDateEditor();
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private final long startTime;

    private FreeworkDateEditor() {
        try {
            this.startTime = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS).parse("1970-01-01 00:00:00").getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (!StringUtils.hasText((String)text)) {
            this.setValue(null);
            return;
        }
        if (text.trim().matches("\\d+")) {
            Long mis = Long.parseLong(text.trim());
            if (mis <= this.startTime) throw new IllegalArgumentException("Could not parse date: " + text);
            this.setValue(new Date(mis));
            return;
        }
        try {
            Date date = FreeworkDateEditor.parseDate(text);
            this.setValue(date);
            return;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not parse date: " + ex.getMessage(), ex);
        }
    }

    public static Date parseDate(String text) {
        try {
            return DateUtils.parseDate((String)text, (String[])new String[]{YYYY_MM_DD_HH_MM_SS, "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd", "yyyy-MM-dd HH", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyyMM", "yyyyMMdd", "yyyyMMddHHmmss", "HH:mm"});
        }
        catch (ParseException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public static String formatHHMM(Object date) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        return format.format(date);
    }

    public static String formatYYYYMMDD(Object date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    public static String formatYYYYMMDDHHMMSS(Object date) {
        SimpleDateFormat format = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        return format.format(date);
    }

    public static String formatLongStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        return format.format(date);
    }

    @Override
    public String getAsText() {
        Date value = (Date)this.getValue();
        return value != null ? new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS).format(value) : "";
    }

    public static void main(String[] args) {
    }
}

