/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.tims.dao.impl;

import com.xdja.pams.bims.bean.PersonTerminal;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.tims.bean.QueryForm;
import com.xdja.pams.tims.entity.MsgPush;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.xatl.tims.bean.TaxMessageBean;
import pams.function.xatl.tims.dao.MsgPushDaoForXatl;

@Repository
public class MsgPushDaoImplForXatl
implements MsgPushDaoForXatl {
    @Autowired
    private BaseDao baseDao;

    @Override
    public MsgPush save(MsgPush msgPush) {
        this.baseDao.create((Object)msgPush);
        return msgPush;
    }

    @Override
    public List<MsgPush> query(QueryForm form, Page page) {
        String sql = "from t_msgpush m,t_person s,t_person r where m.sender=s.id and m.receiver = r.id ";
        ArrayList<String> param = new ArrayList<String>();
        if (form != null && StringUtils.isNotBlank((CharSequence)form.getTitle())) {
            sql = sql + " and m.title like ?";
            param.add("%" + form.getTitle() + "%");
        }
        if (form != null && StringUtils.isNotBlank((CharSequence)form.getContext())) {
            sql = sql + " and m.message like ?";
            param.add("%" + form.getContext() + "%");
        }
        if (form != null && StringUtils.isNotBlank((CharSequence)form.getReceiver())) {
            sql = sql + " and r.name like ?";
            param.add("%" + form.getReceiver() + "%");
        }
        if (form != null && StringUtils.isNotBlank((CharSequence)form.getSender())) {
            sql = sql + " and s.name like ?";
            param.add("%" + form.getSender() + "%");
        }
        if (form != null && StringUtils.isNotBlank((CharSequence)form.getStartDate())) {
            sql = sql + " and m.senddate >= to_date(?, 'YYYY-MM-DD hh24miss')";
            param.add(form.getStartDate().trim() + " 000000");
        }
        if (form != null && StringUtils.isNotBlank((CharSequence)form.getEndDate())) {
            sql = sql + " and m.senddate <= to_date(?, 'YYYY-MM-DD hh24miss')";
            param.add(form.getEndDate().trim() + " 235959");
        }
        Object[] values = null;
        if (param.size() > 0) {
            values = param.toArray(new Object[0]);
        }
        String selectCount = "select count(m.id) " + sql;
        String select = "select m.* " + sql + " order by m.senddate desc";
        return this.baseDao.getListBySQL(selectCount, select, values, page, MsgPush.class);
    }

    @Override
    public List<String> queryAppUserImei(String appId) {
        String sqlQueryAreaType = "select distinct type from T_APP_USE_AREA where type != 'dep' and type != 'person' and app_id = ?";
        List typeList = this.baseDao.getListBySQL(sqlQueryAreaType, (Object[])new String[]{appId}, null);
        ArrayList<String> param = new ArrayList<String>();
        String sql = "select distinct d.imei from t_person p, t_device d where p.id = d.person_id and d.imei is not null and (p.id in (select area_id as person_id from T_APP_USE_AREA where app_id = ? and type='person') ";
        param.add(appId);
        param.add(appId);
        if (typeList != null && typeList.size() > 0) {
            sql = sql + "or p.id in (select id as person_id from t_person pp where pp.dep_id in (select id from t_department connect by prior id = parent_id start with id in (select area_id from  T_APP_USE_AREA where app_id = ? and type='dep')) ";
            for (String type : typeList) {
                if ("dep".equals(type) || "person".equals(type)) continue;
                sql = sql + " and pp." + type + " in (select area_id  from T_APP_USE_AREA where app_id = ? and type='" + type + "')";
                param.add(appId);
            }
            sql = sql + ")";
        } else {
            sql = sql + "or p.id in (select id as person_id from t_person where dep_id in (select id from t_department connect by prior id = parent_id start with id in (select area_id from  T_APP_USE_AREA where app_id = ? and type='dep'))) ";
        }
        sql = sql + ")";
        Object[] values = null;
        if (param.size() > 0) {
            values = param.toArray(new Object[0]);
        }
        return this.baseDao.getListBySQL(sql, values, null);
    }

    @Override
    public List<String> queryAppUserICCID(String appId) {
        String sqlQueryAreaType = "select distinct type from T_APP_USE_AREA where type != 'dep' and type != 'person' and app_id = ?";
        List typeList = this.baseDao.getListBySQL(sqlQueryAreaType, (Object[])new String[]{appId}, null);
        ArrayList<String> param = new ArrayList<String>();
        String sql = "select distinct d.ICCID from t_person p, t_device d where p.id = d.person_id and d.ICCID is not null and (p.id in (select area_id as person_id from T_APP_USE_AREA where app_id = ? and type='person') ";
        param.add(appId);
        param.add(appId);
        if (typeList != null && typeList.size() > 0) {
            sql = sql + "or p.id in (select id as person_id from t_person pp where pp.dep_id in (select id from t_department connect by prior id = parent_id start with id in (select area_id from  T_APP_USE_AREA where app_id = ? and type='dep')) ";
            for (String type : typeList) {
                if ("dep".equals(type) || "person".equals(type)) continue;
                sql = sql + " and pp." + type + " in (select area_id  from T_APP_USE_AREA where app_id = ? and type='" + type + "')";
                param.add(appId);
            }
            sql = sql + ")";
        } else {
            sql = sql + "or p.id in (select id as person_id from t_person where dep_id in (select id from t_department connect by prior id = parent_id start with id in (select area_id from  T_APP_USE_AREA where app_id = ? and type='dep'))) ";
        }
        sql = sql + ")";
        Object[] values = null;
        if (param.size() > 0) {
            values = param.toArray(new Object[0]);
        }
        return this.baseDao.getListBySQL(sql, values, null);
    }

    @Override
    public List<String> queryToPersonIdByDepId(String depId) {
        String sql = "select p.id from t_person p, t_device d where p.flag='0' and p.id=d.person_id and d.imei is not null and length(d.imei) >= 10 and p.dep_id in (select id from t_department connect by prior id = parent_id start with id =  ?)";
        return this.baseDao.getListBySQL(sql, (Object[])new String[]{depId}, null);
    }

    @Override
    public List<String> queryToPersonImeiByDepId(String depId) {
        String sql = "select d.imei from t_person p, t_device d where  p.flag='0' and p.id=d.person_id and d.imei is not null and length(d.imei) >= 10 and p.dep_id in (select id from t_department connect by prior id = parent_id start with id =  ?)";
        return this.baseDao.getListBySQL(sql, (Object[])new String[]{depId}, null);
    }

    @Override
    public List<String> queryToPersonImeiByPersonId(String personId) {
        String sql = "select d.imei from t_person p, t_device d where  p.flag='0' and p.id=d.person_id and d.imei is not null and length(d.imei) >= 10 and p.id = ?";
        return this.baseDao.getListBySQL(sql, (Object[])new String[]{personId}, null);
    }

    @Override
    public List<String> queryToPersonICCIDByPersonId(String personId) {
        String sql = "select d.ICCID from t_device d where  d.ICCID is not null and length(d.ICCID) >= 10 and d.person_id = ?";
        return this.baseDao.getListBySQL(sql, (Object[])new String[]{personId}, null);
    }

    @Override
    public List<String> queryToPersonICCIDByDepId(String depId) {
        String sql = "select d.ICCID from t_person p, t_device d where  p.flag='0' and p.id=d.person_id and d.ICCID is not null and length(d.ICCID) >= 10 and p.dep_id in (select id from t_department connect by prior id = parent_id start with id =  ?)";
        return this.baseDao.getListBySQL(sql, (Object[])new String[]{depId}, null);
    }

    @Override
    public PersonTerminal queryPTByPersonId(String personId) {
        List list = this.baseDao.getListBySQL("select * from T_PERSON_TERMINAL where personId = ? ", (Object[])new String[]{personId}, PersonTerminal.class);
        return (PersonTerminal)list.get(0);
    }

    @Override
    public List<String> queryImeiAndPcid(TaxMessageBean taxMessageBean) {
        return this.queryImeiFromPnImei(taxMessageBean);
    }

    @Override
    public List<String> queryImeiFromPnImei(TaxMessageBean taxMessageBean) {
        StringBuilder sb;
        String[] codes;
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct d.imei||','||p.pc_id ").append(" from t_person p, t_pn_imei d").append(" where p.code = d.code(+)");
        ArrayList<String> obj = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)taxMessageBean.getCods())) {
            codes = taxMessageBean.getCods().split(",");
            sb = new StringBuilder();
            for (String str : codes) {
                sb.append(" ?,");
                obj.add(str);
            }
            sql.append(" and p.code in ( ");
            sql.append(sb.substring(0, sb.length() - 1));
            sql.append(" ) ");
        }
        if (StringUtils.isNotBlank((CharSequence)taxMessageBean.getIds())) {
            codes = taxMessageBean.getIds().split(",");
            sb = new StringBuilder();
            for (String str : codes) {
                sb.append(" ?,");
                obj.add(str);
            }
            sql.append(" and p.id in ( ");
            sql.append(sb.substring(0, sb.length() - 1));
            sql.append(" ) ");
        }
        return this.baseDao.getListBySQL(sql.toString(), obj.toArray(), null);
    }
}

