/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;
import pams.function.xatl.workreport.bean.WorkReport;
import pams.function.xatl.workreport.dao.IWorkReportDao;

@Repository
public class WorkReportDaoImpl
implements IWorkReportDao {
    @Resource
    private BaseDao baseDao;

    @Override
    public String save(WorkReport workReport) {
        this.baseDao.saveOrUpdate((Object)workReport);
        return workReport.getId();
    }

    @Override
    public void save(List<WorkReport> workReports) {
    }

    @Override
    public void update(WorkReport workReport) {
        this.baseDao.update((Object)workReport);
    }

    @Override
    public WorkReport get(String id, Integer diff, Integer offset, String accountId, Double reportOrderDate) {
        StringBuffer select = new StringBuffer();
        ArrayList<Object> values = new ArrayList<Object>();
        select.append(" from WorkReport where accountId = ? ");
        values.add(accountId);
        if (diff >= 0) {
            select.append("and reportOrderDate >= ? ORDER BY reportOrderDate ASC ");
            values.add(reportOrderDate);
        } else {
            select.append(" and reportOrderDate <= ? ORDER BY reportOrderDate DESC ");
            values.add(reportOrderDate);
        }
        String selectCount = "select count(*) " + select.toString();
        List list = this.baseDao.getListByHQL(selectCount, select.toString(), values.toArray(), new Page(offset + 1, 1));
        return null != list && list.size() > 0 ? (WorkReport)list.get(0) : null;
    }

    @Override
    public List<WorkReport> get(String[] ids) {
        StringBuffer select = new StringBuffer();
        ArrayList<String> values = new ArrayList<String>();
        select.append("from WorkReport t where 1 = 1 ");
        if (null != ids && ids.length > 0) {
            for (String id : ids) {
                select.append(" or id = ? ");
                values.add(id);
            }
        }
        return this.baseDao.getListByHQL(select.toString(), values.toArray());
    }

    @Override
    public WorkReport get(String workReportId) {
        return (WorkReport)this.baseDao.getObjectById(WorkReport.class, (Serializable)((Object)workReportId));
    }

    @Override
    public int leftCount(String accountId, Double id) {
        StringBuffer select = new StringBuffer();
        ArrayList<Object> values = new ArrayList<Object>();
        select.append("SELECT count(*) from WorkReport WHERE accountId = ? AND reportOrderDate < ? ");
        values.add(accountId);
        values.add(id);
        Number rst = (Number)this.baseDao.getObjectByHQL(select.toString(), values.toArray());
        return rst.intValue();
    }

    @Override
    public int rightCount(String accountId, Double id) {
        StringBuffer select = new StringBuffer();
        ArrayList<Object> values = new ArrayList<Object>();
        select.append("SELECT count(*) from WorkReport WHERE accountId = ? AND reportOrderDate < ? ");
        values.add(accountId);
        values.add(id);
        Number rst = (Number)this.baseDao.getObjectByHQL(select.toString(), values.toArray());
        return rst.intValue();
    }

    @Override
    public List<WorkReport> listDetail(Long startDate, String accountId) {
        StringBuilder sb = new StringBuilder("from WorkReport ");
        ArrayList<Object> values = new ArrayList<Object>();
        sb.append(" where reportDate = ? ");
        sb.append(" and accountId = ? ");
        values.add(startDate);
        values.add(accountId);
        return this.baseDao.getListByHQL(sb.toString(), values.toArray());
    }

    @Override
    public List<WorkReport> atMeList(String accountId, long time) {
        StringBuilder sb = new StringBuilder("FROM WorkReport ");
        sb.append(" WHERE atIds LIKE '%").append(accountId).append("%'");
        if (time > 0L) {
            sb.append(" and createTime < ").append(time);
        }
        StringBuilder countSql = new StringBuilder("SELECT count(*) ");
        countSql.append(sb.toString());
        sb.append(" ORDER BY createTime DESC ");
        return this.baseDao.getListByHQL(countSql.toString(), sb.toString(), null, new Page(1, 10));
    }

    @Override
    public void del(String id) {
        WorkReport workReport = this.get(id);
        this.baseDao.delete((Object)workReport);
    }

    @Override
    public List<WorkReport> reportMonth(Long startDate, Long endDate, String accountId) {
        StringBuffer select = new StringBuffer();
        ArrayList<Object> values = new ArrayList<Object>();
        select.append("SELECT bwr.c_id id, bwr.c_content content, bda.c_operate_content operateContent, bwr.n_report_date reportDate");
        select.append(" FROM t_business_work_report bwr ");
        select.append("LEFT JOIN t_business_work_report_approva bda ON bwr.c_id = bda.c_work_report_id ");
        select.append("WHERE bwr.c_account_id = ? AND bwr.n_report_date >= ? AND bwr.n_report_date <= ? ORDER BY n_report_date ASC ");
        values.add(accountId);
        values.add(startDate);
        values.add(endDate);
        List list = this.baseDao.getListBySQL(select.toString(), values.toArray(), Map.class);
        ArrayList<WorkReport> listWorkReport = new ArrayList<WorkReport>();
        if (null != list && list.size() > 0) {
            WorkReport workReport = null;
            for (Map map : list) {
                workReport = new WorkReport();
                String id = map.get("ID") == null ? null : map.get("ID") + "";
                String content = map.get("CONTENT") == null ? null : map.get("CONTENT") + "";
                String operaterContent = map.get("OPERATECONTENT") == null ? null : map.get("OPERATECONTENT") + "";
                String reportDate = map.get("REPORTDATE") == null ? null : map.get("REPORTDATE") + "";
                workReport.setId(id);
                workReport.setContent(content);
                workReport.setOperateContent(operaterContent);
                workReport.setReportDate(Long.parseLong(reportDate));
                listWorkReport.add(workReport);
            }
        }
        return listWorkReport;
    }
}

