/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.rpcMethod;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.jsonrpc.LakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.workreport.bean.AccountFollow;
import pams.function.xatl.workreport.bean.AccountFollowReponse;
import pams.function.xatl.workreport.constans.RedisConstants;
import pams.function.xatl.workreport.service.IAccountFollowService;
import pams.function.xatl.workreport.util.DateUtil;
import pams.function.xatl.workreport.util.RedisUtil;

@Service
public class FollowList
extends LakeMobMethod {
    @Autowired
    private IAccountFollowService accountFollowService;
    @Autowired
    private UserManageService userManageService;
    private RedisUtil.Strings strings = new RedisUtil.Strings(RedisUtil.getInstance());

    @Override
    protected Object execute0(String currentUser, SuperRequest request) throws Exception {
        this.logger.debug("FollowList \u6211\u5173\u6ce8\u7684\u5217\u8868>>>currentUser: \u3010{}\u3011, params: \u3010{}\u3011", (Object)currentUser, (Object)request.toJsonString());
        List<AccountFollow> accountFollowList = this.accountFollowService.list(currentUser);
        ArrayList<AccountFollowReponse> afResponse = new ArrayList<AccountFollowReponse>();
        if (accountFollowList != null && accountFollowList.size() > 0) {
            for (AccountFollow accountFollow : accountFollowList) {
                Person person = this.userManageService.queryPersonById(accountFollow.getFollowAccountId());
                if (!person.getFlag().equals("0")) continue;
                AccountFollowReponse afr = new AccountFollowReponse();
                afr.setFollowAccountId(accountFollow.getFollowAccountId());
                afr.setFollowAccountName(person.getName());
                afr.setFollowAccountAvatarUrl(null);
                Map<String, Object> followAccountReportMap = this.getFollowAccountReportMap(currentUser, accountFollow.getFollowAccountId(), person.getName());
                afr.setFinalReportDate(String.valueOf(followAccountReportMap.get("finalReportDate")));
                afr.setIsUpdate(Boolean.parseBoolean(String.valueOf(followAccountReportMap.get("isUpdate"))));
                afResponse.add(afr);
            }
        }
        this.logger.debug("FollowList \u6211\u5173\u6ce8\u7684\u5217\u8868<<<currentUser: \u3010{}\u3011, params: \u3010{}\u3011, resp: \u3010{}\u3011", new Object[]{currentUser, request.toJsonString(), JSON.toJSONString(afResponse)});
        return afResponse;
    }

    private Map<String, Object> getFollowAccountReportMap(String accountId, String followAccountId, String followAccountName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String reportDateAndCreateTime = this.strings.get(RedisConstants.getBusinessWorkReportKey(followAccountId));
        if (StringUtils.isNotBlank((CharSequence)reportDateAndCreateTime) && reportDateAndCreateTime.split("\\|").length == 2) {
            String[] reportDateAndCreateTimeArray = reportDateAndCreateTime.split("\\|");
            String reportDate = reportDateAndCreateTimeArray[0];
            this.logger.debug("reportDate{}", (Object)reportDate);
            String monthDate = reportDate.substring(4);
            StringBuilder sb = new StringBuilder(monthDate);
            sb.insert(2, "-");
            this.logger.debug("\u8fd4\u56de\u7ed9\u7ec8\u7aef\u5c55\u793a\u65e5\u671f{}", (Object)sb.toString());
            String reportCreateTime = reportDateAndCreateTimeArray[1];
            resultMap.put("finalReportDate", sb.toString());
            int criticalValueUpdateReport = 5;
            Date today = DateUtil.getTodayZeroHour();
            if (DateUtil.givedTimeToBeforeOrAfter(reportDate, criticalValueUpdateReport * 24 * 60 * 60, "yyyyMMdd").getTime() >= today.getTime()) {
                String businessWorkReportControllerBrowse = this.strings.get(RedisConstants.getBusinessWorkReportControllerBrowseKey(accountId, followAccountId));
                if (StringUtils.isNotBlank((CharSequence)businessWorkReportControllerBrowse) && Long.parseLong(reportCreateTime) < Long.parseLong(businessWorkReportControllerBrowse)) {
                    resultMap.put("isUpdate", Boolean.FALSE);
                } else {
                    resultMap.put("isUpdate", Boolean.TRUE);
                }
            } else {
                resultMap.put("isUpdate", Boolean.FALSE);
            }
        } else {
            this.logger.warn("\u5458\u5de5{}\u6ca1\u6709\u5de5\u4f5c\u6c47\u62a5", (Object)followAccountName);
            resultMap.put("finalReportDate", "");
            resultMap.put("isUpdate", Boolean.FALSE);
        }
        return resultMap;
    }
}

