package com.xdja.cssp.account.service.api;

import com.xdja.cssp.account.service.api.bean.AccountInfo;
import com.xdja.cssp.account.service.api.bean.UpdateResult;
import com.xdja.platform.rpc.RemoteService;

/**
 * 
 * 账户服务rpc接口
 * @date 2015-7-20
 * @author rrx
 *
 */
@RemoteService(serviceCode=Constants.RPC_SERVICE_CODE)
public interface AccountService {

	/**
	 * 
	 * 分批次获取与发起账户更新请求的账号相关（是好友、在相同的群组、在同一个集团）的有变更的账户信息
	 * 
	 * @param account       发起账户信息增量更新的账号
	 * @param lastUpdateId  账户信息最后更新标识，默认为-1
	 * @param batchSize     本批次更新的数量，默认为10
	 * @return
	 */
	UpdateResult queryAccounts(String account, Long lastUpdateId, Integer batchSize);

	/**
	 * 
	 * 方法描述：查询帐户所属的集团代码
	 * @author: fy
	 * @date: 2015-7-23 下午2:41:01
	 * @param account
	 * @return
	 */
	String getEcCodeByAccount(String account);
	
	/**
	 * 
	 * 方法描述：通过卡号获取帐号
	 * @author: fy
	 * @date: 2015-10-16 下午1:47:58
	 * @param cardNo
	 * @return AccountInfo
	 */
	AccountInfo getAccountByCardNo(String cardNo);
}
