package com.xdja.cssp.as.auth;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;

/**
 * 系统常量
 * @author wyf
 *
 */
public class Constants {
	
	/**
	 * HTTP消息头中签名算法标识 RSA
	 */
	public final static String HTTP_HEADER_SIGN_METHOD_RSA = "SHA1WITHRSA";
	/**
	 * HTTP消息头中签名算法标识 SM2
	 */
	public final static String HTTP_HEADER_SIGN_METHOD_SM2 = "SM3WITHSM2";
	
	/**
	 * HTTP消息头KEY 业务key开头
	 */
	public final static String HEADER_NAME_START = "x-at-";
	/**
	 * HTTP消息头KEY API版本号
	 */
	public final static String VERSION_HEADER_NAME = "x-at-version";
	/**
	 * HTTP消息头KEY 终端签名证书sn
	 */
	public final static String SIGNATURE_SN_HEADER_NAME = "x-at-signature-sn";
	/**
	 * HTTP消息头KEY 终端签名证书dn
	 */
	public final static String SIGNATURE_DN_HEADER_NAME = "x-at-signature-dn";
	/**
	 * HTTP消息头KEY 签名方式
	 */
	public final static String SIGNATURE_METHOD_HEADER_NAME = "x-at-signature-method";
	/**
	 * HTTP消息头KEY 请求的时间戳
	 */
	public final static String TIMESTAMP_HEADER_NAME = "x-at-timestamp";
	/**
	 * HTTP消息头KEY 签名算法版本
	 */
	public final static String SIGNATURE_VERSION_HEADER_NAME = "x-at-signature-version";
	/**
	 * HTTP消息头KEY 唯一随机数
	 */
	public final static String SIGNATURE_NONCE_HEADER_NAME = "x-at-signature-nonce";
	/**
	 * HTTP消息头KEY 签名信息
	 */
	public static String AUTHORIZATION_HEADER_NAME = "Authorization";
	
	
	/**
	 * 解析时间戳
	 * @throws ParseException 
	 */
	public static Date parseTimestamp(String timestamp) throws ParseException {
		String formatTimestamp = timestamp.substring(0, 10) + " " + timestamp.substring(11,19);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return sdf.parse(formatTimestamp);
	}
	
	/**
	 * 生成canonicalizeRequest
	 * @throws UnsupportedEncodingException 
	 */
	public static String generateCanonicalizeRequest(String method, String uri, String queryString,
			List<Header> headers, String requestBody) throws UnsupportedEncodingException {
		String canonicalizeUri = canonicalizeUri(uri);
		String canonicalizeQueryString = canonicalizeQueryString(queryString);
		String canonicalizeHeaders = canonicalizeHeaders(headers);
		String canonicalizeRequest = canonicalizeRequest(method, canonicalizeUri, canonicalizeQueryString, canonicalizeHeaders, requestBody);
		return canonicalizeRequest;
	}
	
	private static String canonicalizeQueryString(String queryString) throws UnsupportedEncodingException {
		StringBuffer result = new StringBuffer();
		if (StringUtils.isBlank(queryString)) {
			return result.toString();
		}
		
		String[] queryData = StringUtils.split(queryString, "&");
		
		List<String> queryList = new ArrayList<>();
		
		String[] temp = null;
		String value = null;
		for (int i = 0; i < queryData.length; i++) {
			value = queryData[i];
			
			if (StringUtils.isBlank(value)) {
				continue;
			}
			
			temp = StringUtils.split(value, "=");
			
			if (temp[0].equalsIgnoreCase(Constants.AUTHORIZATION_HEADER_NAME)) {
				continue;
			}
			
			if (temp.length == 1) {
				queryList.add(URLEncoder.encode(temp[0], "UTF-8") + "=");
			} else if (temp.length >= 2) {
				queryList.add(URLEncoder.encode(temp[0], "UTF-8") + "=" + URLEncoder.encode(temp[1], "UTF-8"));
			}
		}
		
		Collections.sort(queryList);
		
		for (String item : queryList) {
			result.append(item).append("&");
		}
		
		if (result.length() > 0) {
			return result.substring(0, result.lastIndexOf("&"));
		}
		
		return result.toString();
	}
	
	/**
	 * 规范化URI
	 * @throws UnsupportedEncodingException 
	 */
	private static String canonicalizeUri(String uri) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        byte[] bytes = uri.getBytes("utf-8");
        byte[] tmp;
        for (int i = 0; i < bytes.length; i++) {
            if ((bytes[i] >= 'A' && bytes[i] <= 'Z') || (bytes[i] >= 'a' && bytes[i] <= 'z') 
            		|| (bytes[i] >= '0' && bytes[i] <= '9') || bytes[i] == '_' || bytes[i] == '-' 
            		|| bytes[i] == '~' || bytes[i] == '.') {
            	tmp = new byte[1];
            	tmp[0] = bytes[i];
                result.append(new String(tmp, "utf-8"));
            } else {
            	tmp = new byte[1];
            	tmp[0] = bytes[i];
                result.append('%' + byte2hex(tmp).toUpperCase());
            }
        }
        return result.toString();
	}
	
	/**
     * 字节数组转十六进制
     * @param bytes 字节数组
     * @return 二进制字符串
     */
	private static String byte2hex(byte[] bytes) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < bytes.length; n++) {
            stmp = (java.lang.Integer.toHexString(bytes[n] & 0xFF));
            if (stmp.length() == 1) {
            	hs = hs + "0" + stmp;
            } else {
            	hs = hs + stmp;
            }
        }
        return hs;
    }
	
	/**
	 * 规范Header
	 * @param headers
	 * @return
	 */
	private static String canonicalizeHeaders(List<Header> headers) {
		String canonicalHeaders = "";

		if (headers != null) {
			for (Header header : headers) {
				canonicalHeaders = canonicalHeaders + header.getName().toLowerCase().trim() 
						+ ":" + header.getValue().trim() + "\n";
			}
		}

		if ("" == canonicalHeaders) {
			canonicalHeaders = canonicalHeaders + "\n";
		}
		return canonicalHeaders;
	}
	
	/**
	 * 规范化请求
	 */
	private static String canonicalizeRequest(String method,
			String canonicalizeUri, String canonicalizeQueryString,
			String canonicalizeHeaders, String requestBody) {
		String canonicalizeRequest = method.toUpperCase() + "\n" + canonicalizeUri + "\n" 
				 + canonicalizeQueryString + "\n" + canonicalizeHeaders + requestBody;
		return canonicalizeRequest;
	}

}
