package com.xdja.cssp.as.auth.exception;

import org.springframework.http.HttpStatus;

import com.xdja.cssp.restful.auth.exception.AuthException;

/**
 * 无效的API版本
 * @author wyf
 *
 */
public class InvalidApiVersionException extends AuthException {

	private static final long serialVersionUID = 1L;
	
	public InvalidApiVersionException(String hostId, String requestId, String errCode, String message)
    {
        this(hostId, requestId, errCode, message, null);
    }

	public InvalidApiVersionException(String hostId, String requestId,
			String errCode, String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	@Override
	public int getStatus() {
		return HttpStatus.BAD_REQUEST.value();
	}

}
