package com.xdja.cssp.as.auth.exception;

import org.springframework.http.HttpStatus;

import com.xdja.cssp.restful.auth.exception.AuthException;

/**
 * 无效的时间异常
 * @author yk
 *
 */
public class InvalidDateException extends AuthException {

	/**
	 * @Fields serialVersionUID:
	 *
	 */
	private static final long serialVersionUID = -4926703811347116508L;
	
	public static final HttpStatus HTTP_STATUS = HttpStatus.BAD_REQUEST;
	
	public InvalidDateException(String hostId,
			String requestId, String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	public InvalidDateException(String hostId, String requestId, String errCode,
			String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}
}
