package com.xdja.cssp.as.auth.exception;

import org.springframework.http.HttpStatus;

import com.xdja.cssp.restful.auth.exception.AuthException;

/**
 * 不支持的签名算法异常
 * @author yk
 *
 */
public class NotSupportSignAlgoException extends AuthException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5828722368805746792L;
	
	public static final HttpStatus HTTP_STATUS = HttpStatus.BAD_REQUEST;
	
	public NotSupportSignAlgoException(String hostId,
			String requestId, String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	public NotSupportSignAlgoException(String hostId, String requestId,
			String errCode, String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}
}
