/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.friend.server.business;

import com.xdja.platform.redis.core.RedisClient;
import com.xdja.platform.redis.core.action.JedisActionNoResult;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

@Component
public class FriendCacheOperator {
    private static String KEY_PREFIX = "friend:";
    private static String UPDATE_SERIAL = "update_serial";
    private static Logger logger = LoggerFactory.getLogger(FriendCacheOperator.class);
    private static RedisClient rc;

    @Resource(name="atRC")
    public void setRedisClient(RedisClient rc) {
        FriendCacheOperator.rc = rc;
    }

    public static void addFriend(final String account, final String friendAccount, final long updateSerial) {
        rc.execute(new JedisActionNoResult(){

            public void action(Jedis jedis) {
                Pipeline pl = jedis.pipelined();
                pl.sadd(KEY_PREFIX + account, new String[]{friendAccount});
                pl.sadd(KEY_PREFIX + friendAccount, new String[]{account});
                pl.set(KEY_PREFIX + UPDATE_SERIAL, String.valueOf(updateSerial));
                pl.sync();
            }
        });
        logger.info("Add friend to redis , account:{}, friendAccount:{}", (Object)account, (Object)friendAccount);
    }

    public static void setUpdateSerial(long updateSerial) {
        rc.set(KEY_PREFIX + UPDATE_SERIAL, String.valueOf(updateSerial));
    }

    public static long getUpdateSerial() {
        String updateSerialStr = rc.get(KEY_PREFIX + UPDATE_SERIAL);
        if (StringUtils.isNotBlank((CharSequence)updateSerialStr)) {
            return Long.parseLong(updateSerialStr);
        }
        return -1L;
    }

    public static void deleteFriend(final String account, final String friendAccount) {
        rc.execute(new JedisActionNoResult(){

            public void action(Jedis jedis) {
                Pipeline pl = jedis.pipelined();
                pl.srem(KEY_PREFIX + account, new String[]{friendAccount});
                pl.srem(KEY_PREFIX + friendAccount, new String[]{account});
                pl.sync();
            }
        });
        logger.info("Delete friend from redis , account:{}, friendAccount:{}", (Object)account, (Object)friendAccount);
    }

    public static void loadFriends(final Map<String, Set<String>> friendMap, final long updateSerial) {
        if (friendMap == null || friendMap.isEmpty()) {
            logger.info("no friend data to cache .");
            return;
        }
        rc.execute(new JedisActionNoResult(){

            public void action(Jedis jedis) {
                Pipeline pl = jedis.pipelined();
                for (Map.Entry friendEntry : friendMap.entrySet()) {
                    String account = (String)friendEntry.getKey();
                    Set friendSet = (Set)friendEntry.getValue();
                    if (friendSet == null) continue;
                    String[] friendArray = new String[friendSet.size()];
                    friendSet.toArray(friendArray);
                    pl.sadd(KEY_PREFIX + account, friendArray);
                }
                pl.set(KEY_PREFIX + UPDATE_SERIAL, String.valueOf(updateSerial));
                pl.sync();
            }
        });
        logger.info("cache friend data success.");
    }
}

