/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.friend.server.business.impl;

import com.xdja.cssp.friend.server.business.FriendCacheOperator;
import com.xdja.cssp.friend.server.business.IFriendBusiness;
import com.xdja.cssp.friend.server.dao.IFriendDao;
import com.xdja.cssp.friend.server.util.PinyinUtil;
import com.xdja.cssp.generated.service.IGeneratedKeyService;
import com.xdja.friend.service.model.Friend;
import com.xdja.friend.service.model.FriendReq;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class FriendBusinessImpl
implements IFriendBusiness {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IFriendDao friendDao;
    private static String SERIAL_TYPE_FRIEND = "friend";
    private static String SERIAL_TYPE_FRIEND_REQ = "friendReq";
    private IGeneratedKeyService generatedKeyService = (IGeneratedKeyService)DefaultServiceRefer.getServiceRefer(IGeneratedKeyService.class);

    @Override
    public List<Friend> queryFriends(String account, long lastUpdateSerial) {
        if (lastUpdateSerial <= 0L) {
            return this.friendDao.queryNormalFriends(account);
        }
        return this.friendDao.queryFriends(account, lastUpdateSerial);
    }

    @Override
    public long friendRequest(FriendReq friendReq) {
        if (friendReq.getAccount().equals(friendReq.getFriendAccount())) {
            return -3L;
        }
        if (this.isFriend(friendReq.getAccount(), friendReq.getFriendAccount())) {
            return -1L;
        }
        long time = System.currentTimeMillis();
        long updateSerial = this.generatedKeyService.generateId(SERIAL_TYPE_FRIEND_REQ);
        friendReq.setTime(time);
        friendReq.setUpdateSerial(updateSerial);
        return this.friendDao.saveFriendRequest(friendReq);
    }

    @Override
    public FriendReq queryFriendReqById(long id) {
        return this.friendDao.queryFriendReqById(id);
    }

    @Override
    public Friend queryFriend(String account, String friendAccount) {
        Friend friend = this.friendDao.queryFriend(account, friendAccount);
        if (friend == null || friend.getState() == Friend.STATE_DELETE) {
            return null;
        }
        return friend;
    }

    @Override
    public long createFriend(String account, String friendAccount) {
        long id;
        Friend queryfriend = this.friendDao.queryFriend(account, friendAccount);
        boolean delRecordFlag = false;
        if (queryfriend != null) {
            if (queryfriend.getState() != Friend.STATE_DELETE) {
                return -1L;
            }
            delRecordFlag = true;
        }
        FriendReq friendReq = this.friendDao.queryLastFriendReq(friendAccount, account);
        FriendReq friendReq2 = this.friendDao.queryLastFriendReq(account, friendAccount);
        if (friendReq == null) {
            return -2L;
        }
        String remark = friendReq2 != null ? friendReq2.getRemark() : "";
        if (delRecordFlag) {
            this.friendDao.deleteFriendRecord(account, friendAccount);
        }
        Friend friend = new Friend();
        friend.setAccount(account);
        friend.setFriendAccount(friendAccount);
        friend.setRemark(remark);
        friend.setRemarkPinyin(PinyinUtil.getCharactersPinyin(remark));
        friend.setRemarkPy(PinyinUtil.getCharactersPy(remark));
        long createTime = System.currentTimeMillis();
        friend.setCreateTime(createTime);
        Long genId = this.generatedKeyService.generateId(SERIAL_TYPE_FRIEND);
        friend.setUpdateSerial(genId);
        if (delRecordFlag) {
            friend.setState(Friend.STATE_UPDATE);
        }
        try {
            id = this.friendDao.saveFriend(friend);
            remark = friendReq.getRemark();
            friend = new Friend();
            friend.setAccount(friendAccount);
            friend.setFriendAccount(account);
            friend.setRemark(remark);
            friend.setRemarkPinyin(PinyinUtil.getCharactersPinyin(remark));
            friend.setRemarkPy(PinyinUtil.getCharactersPy(remark));
            friend.setCreateTime(createTime);
            friend.setUpdateSerial(genId);
            if (delRecordFlag) {
                friend.setState(Friend.STATE_UPDATE);
            }
            this.friendDao.saveFriend(friend);
        }
        catch (DuplicateKeyException e) {
            this.logger.error("already friend", (Throwable)e);
            return -1L;
        }
        this.friendDao.deleteFriendReq(account, friendAccount);
        FriendCacheOperator.addFriend(account, friendAccount, genId);
        return id;
    }

    @Override
    public Friend queryFriendById(long id) {
        return this.friendDao.queryFriendById(id);
    }

    @Override
    public long updateRemark(String account, String friendAccount, String remark) {
        Friend queryfriend = this.friendDao.queryFriend(account, friendAccount);
        if (queryfriend == null || queryfriend.getState() == Friend.STATE_DELETE) {
            return -4L;
        }
        String remarkPy = PinyinUtil.getCharactersPy(remark);
        String remarkPinyin = PinyinUtil.getCharactersPinyin(remark);
        Long genId = this.generatedKeyService.generateId(SERIAL_TYPE_FRIEND);
        this.friendDao.setRemark(account, friendAccount, remark, remarkPy, remarkPinyin, genId);
        FriendCacheOperator.setUpdateSerial(genId);
        return 0L;
    }

    @Override
    public long deleteFriend(String account, String friendAccount) {
        long ret = -4L;
        Friend friend = this.friendDao.queryFriend(friendAccount, account);
        Long genId = this.generatedKeyService.generateId(SERIAL_TYPE_FRIEND);
        if (friend != null && friend.getState() != Friend.STATE_DELETE) {
            ret = friend.getId();
            this.friendDao.deleteFriend(friendAccount, account, genId);
        }
        this.friendDao.deleteFriend(account, friendAccount, genId);
        FriendCacheOperator.deleteFriend(account, friendAccount);
        return ret;
    }

    @Override
    public List<FriendReq> queryFriendReq(String account, long lastQuerySerial) {
        return this.friendDao.queryFriendReq(account, lastQuerySerial);
    }

    private boolean isFriend(String account, String friendAccount) {
        Friend friend = this.friendDao.queryFriend(friendAccount, account);
        return friend != null && friend.getState() != Friend.STATE_DELETE;
    }

    @Override
    public void loadFriendToCache() {
        long cachedUpdateSerial = FriendCacheOperator.getUpdateSerial();
        List<Friend> friends = this.friendDao.queryNormalFriends(cachedUpdateSerial);
        if (friends == null || friends.size() == 0) {
            this.logger.info("no friends data need to cache .");
            return;
        }
        this.logger.info("find {} records to cache ...", (Object)friends.size());
        cachedUpdateSerial = friends.get(0).getUpdateSerial();
        HashMap<String, Set<String>> friendMap = new HashMap<String, Set<String>>();
        for (Friend friend : friends) {
            String account = friend.getAccount();
            String friendAccount = friend.getFriendAccount();
            HashSet<String> friendSet = (HashSet<String>)friendMap.get(account);
            if (friendSet == null) {
                friendSet = new HashSet<String>();
                friendMap.put(account, friendSet);
            }
            friendSet.add(friendAccount);
        }
        FriendCacheOperator.loadFriends(friendMap, cachedUpdateSerial);
        this.logger.info("friend data cached success.");
    }
}

