/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.friend.server.dao.impl;

import com.xdja.cssp.friend.server.dao.IFriendDao;
import com.xdja.friend.service.model.Friend;
import com.xdja.friend.service.model.FriendReq;
import com.xdja.platform.datacenter.jpa.dao.BaseJdbcDao;
import java.util.HashMap;
import java.util.List;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class FriendDaoByJdbcTemplate
extends BaseJdbcDao
implements IFriendDao {
    @Override
    public List<Friend> queryFriends(String account, long lastQuerySerial) {
        StringBuilder sqlSb = new StringBuilder("SELECT n_id id, c_account account, ");
        sqlSb.append("c_friend_account friendAccount, c_remark remark,c_remark_py remarkPy,").append("c_remark_pinyin remarkPinyin,n_create_time createTime,").append("n_update_serial updateSerial,n_state state FROM t_friend ").append("WHERE c_account = :account AND n_update_serial > :lastQuerySerial ");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account", account);
        params.put("lastQuerySerial", lastQuerySerial);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(Friend.class);
        return this.jdbcOperator.namedJdbcTemplate.query(sqlSb.toString(), params, (RowMapper)rowMapper);
    }

    @Override
    public List<Friend> queryNormalFriends(String account) {
        StringBuilder sqlSb = new StringBuilder("SELECT n_id id, c_account account, ");
        sqlSb.append("c_friend_account friendAccount, c_remark remark,c_remark_py remarkPy,").append("c_remark_pinyin remarkPinyin,n_create_time createTime,").append("n_update_serial updateSerial,n_state state FROM t_friend ").append("WHERE c_account = :account AND n_state != :state ");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account", account);
        params.put("state", Friend.STATE_DELETE);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(Friend.class);
        return this.jdbcOperator.namedJdbcTemplate.query(sqlSb.toString(), params, (RowMapper)rowMapper);
    }

    @Override
    public long saveFriendRequest(FriendReq friendReq) {
        StringBuilder sql = new StringBuilder();
        sql.append(" insert into t_friend_req (c_req_account, c_rec_account, c_remark,").append(" c_verification, n_time, n_update_serial) ").append(" VALUES(:account, :friendAccount, :remark, :verification, :time, :updateSerial) ");
        BeanPropertySqlParameterSource beanPropertySqlParameterSource = new BeanPropertySqlParameterSource((Object)friendReq);
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcOperator.namedJdbcTemplate.update(sql.toString(), (SqlParameterSource)beanPropertySqlParameterSource, (KeyHolder)keyHolder, new String[]{"n_id"});
        return keyHolder.getKey().longValue();
    }

    @Override
    public FriendReq queryFriendReqById(long id) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("SELECT n_id id, c_req_account account, c_rec_account friendAccount,").append("c_remark remark, c_verification cerfication,n_time time,n_update_serial updateSerial ").append("FROM t_friend_req WHERE n_id = :id ");
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FriendReq.class);
        List reqs = this.jdbcOperator.namedJdbcTemplate.query(sqlSb.toString(), paramMap, (RowMapper)rowMapper);
        if (reqs.size() > 0) {
            return (FriendReq)reqs.get(0);
        }
        return null;
    }

    @Override
    public long saveFriend(Friend friend) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("INSERT into t_friend(c_account, c_friend_account, c_remark, c_remark_py, ").append("c_remark_pinyin, n_create_time, n_update_serial, n_state) ").append("values(:account,:friendAccount,:remark,:remarkPy,:remarkPinyin,:createTime,:updateSerial,:state)");
        BeanPropertySqlParameterSource beanPropertySqlParameterSource = new BeanPropertySqlParameterSource((Object)friend);
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcOperator.namedJdbcTemplate.update(sqlSb.toString(), (SqlParameterSource)beanPropertySqlParameterSource, (KeyHolder)keyHolder, new String[]{"n_id"});
        return keyHolder.getKey().longValue();
    }

    @Override
    public Friend queryFriendById(long id) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("SELECT n_id id, c_account account, c_friend_account friendAccount, c_remark remark,").append("c_remark_py remarkPy, c_remark_pinyin remarkPinyin, n_create_time createTime,").append("n_update_serial updateSerial,n_state state ").append("FROM t_friend WHERE n_id = :id ");
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(Friend.class);
        List friends = this.jdbcOperator.namedJdbcTemplate.query(sqlSb.toString(), paramMap, (RowMapper)rowMapper);
        if (friends.size() > 0) {
            return (Friend)friends.get(0);
        }
        return null;
    }

    @Override
    public void setRemark(String account, String friendAccount, String remark, String remarkPy, String remarkPinyin, long updateSerial) {
        StringBuilder sql = new StringBuilder("UPDATE t_friend f SET f.c_remark = :remark, ").append(" f.c_remark_pinyin = :remarkPinyin, f.c_remark_py =  :remarkPy,").append(" f.n_update_serial = :updateSerial, n_state = :state ").append(" WHERE f.c_account = :account and f.c_friend_account = :friendAccount AND n_state != :oldState ");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("remark", remark);
        paramMap.put("remarkPinyin", remarkPinyin);
        paramMap.put("remarkPy", remarkPy);
        paramMap.put("account", account);
        paramMap.put("friendAccount", friendAccount);
        paramMap.put("state", Friend.STATE_UPDATE);
        paramMap.put("updateSerial", updateSerial);
        paramMap.put("oldState", Friend.STATE_DELETE);
        this.jdbcOperator.namedJdbcTemplate.update(sql.toString(), paramMap);
    }

    @Override
    public void deleteFriend(String account, String friendAccount, long updateSerial) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("UPDATE t_friend set n_state = :state, n_update_serial = :updateSerial ").append(" WHERE c_account = :account and c_friend_account = :friendAccount AND n_state != :state");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("state", Friend.STATE_DELETE);
        paramMap.put("account", account);
        paramMap.put("friendAccount", friendAccount);
        paramMap.put("updateSerial", updateSerial);
        this.jdbcOperator.namedJdbcTemplate.update(sqlSb.toString(), paramMap);
    }

    @Override
    public List<FriendReq> queryFriendReq(String account, long lastQuerySerial) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("SELECT n_id id, c_req_account account, c_rec_account friendAccount,").append("c_remark remark, c_verification verification,n_time time,n_update_serial updateSerial ").append("FROM t_friend_req ").append("WHERE c_rec_account = :recAccount AND n_update_serial > :lastQuerySerial ORDER BY n_update_serial DESC");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("recAccount", account);
        paramMap.put("lastQuerySerial", lastQuerySerial);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FriendReq.class);
        return this.jdbcOperator.namedJdbcTemplate.query(sqlSb.toString(), paramMap, (RowMapper)rowMapper);
    }

    @Override
    public FriendReq queryLastFriendReq(String reqAccount, String recAccount) {
        FriendReq friendReq = null;
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("SELECT n_id id, c_req_account account, c_rec_account friendAccount,").append("c_remark remark, c_verification cerfication,n_time time,n_update_serial updateSerial ").append("FROM t_friend_req ").append("WHERE c_req_account = :reqAccount AND c_rec_account = :recAccount ORDER BY n_update_serial DESC");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("reqAccount", reqAccount);
        paramMap.put("recAccount", recAccount);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FriendReq.class);
        List friendReqs = this.jdbcOperator.namedJdbcTemplate.query(sqlSb.toString(), paramMap, (RowMapper)rowMapper);
        if (friendReqs != null && friendReqs.size() > 0) {
            friendReq = (FriendReq)friendReqs.get(0);
        }
        return friendReq;
    }

    @Override
    public Friend queryFriend(String account, String friendAccount) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("SELECT n_id id, c_account account, c_friend_account friendAccount, c_remark remark,").append("c_remark_py remarkPy, c_remark_pinyin remarkPinyin, n_create_time createTime,").append("n_update_serial updateSerial,n_state state ").append("FROM t_friend ").append("WHERE c_account = :account AND c_friend_account = :friendAccount ORDER BY n_update_serial DESC ");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("account", account);
        paramMap.put("friendAccount", friendAccount);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(Friend.class);
        List friends = this.jdbcOperator.namedJdbcTemplate.query(sqlSb.toString(), paramMap, (RowMapper)rowMapper);
        if (friends != null && friends.size() > 0) {
            return (Friend)friends.get(0);
        }
        return null;
    }

    @Override
    public void deleteFriendReq(String account, String friendAccount) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("DELETE FROM t_friend_req ").append("WHERE (c_req_account = :account AND c_rec_account = :friendAccount) ").append("OR (c_req_account = :friendAccount AND c_rec_account = :account) ");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("account", account);
        paramMap.put("friendAccount", friendAccount);
        this.jdbcOperator.namedJdbcTemplate.update(sqlSb.toString(), paramMap);
    }

    @Override
    public void deleteFriendRecord(String account, String friendAccount) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("DELETE FROM t_friend WHERE (c_account = :account and c_friend_account = :friendAccount) OR (c_account = :friendAccount and c_friend_account = :account ) ");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("account", account);
        paramMap.put("friendAccount", friendAccount);
        this.jdbcOperator.namedJdbcTemplate.update(sqlSb.toString(), paramMap);
    }

    @Override
    public List<Friend> queryAllNormalFriends() {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("SELECT c_account account, c_friend_account friendAccount ").append("FROM t_friend ").append("WHERE n_state != :state");
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("state", Friend.STATE_DELETE);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(Friend.class);
        return this.jdbcOperator.namedJdbcTemplate.query(sqlSb.toString(), paramMap, (RowMapper)rowMapper);
    }

    @Override
    public List<Friend> queryNormalFriends(long updateSerial) {
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("SELECT c_account account, c_friend_account friendAccount, n_update_serial updateSerial ").append("FROM t_friend ").append("WHERE n_state != :state AND n_update_serial > :updateSerial ORDER BY n_update_serial DESC ");
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("state", Friend.STATE_DELETE);
        paramMap.put("updateSerial", updateSerial);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(Friend.class);
        return this.jdbcOperator.namedJdbcTemplate.query(sqlSb.toString(), paramMap, (RowMapper)rowMapper);
    }
}

