/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.friend.server.scheduling;

import com.xdja.cssp.friend.server.business.IFriendBusiness;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class FriendDataCacher
implements ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(FriendDataCacher.class);
    private static IFriendBusiness friendBusiness;
    private static boolean caching;
    private static ExecutorService es;

    public static boolean isCaching() {
        return caching;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        friendBusiness = (IFriendBusiness)applicationContext.getBean(IFriendBusiness.class);
    }

    public static synchronized boolean startCache() {
        if (FriendDataCacher.isCaching()) {
            return false;
        }
        logger.debug("start cache ...");
        caching = true;
        es.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    friendBusiness.loadFriendToCache();
                }
                finally {
                    caching = false;
                }
            }
        });
        logger.debug("end cache ...");
        return true;
    }

    static {
        caching = false;
        es = Executors.newSingleThreadExecutor();
    }
}

