package com.xdja.cssp.restful.exception;

import org.springframework.http.HttpStatus;


/**
 * 请求错误
 * <br>Http状态码 400
 * @author Administrator
 * 
 *
 */
public class BadRequestException extends ApiException {


	/**
	 * 
	 */
	private static final long serialVersionUID = -2919563285214572577L;



	public static final HttpStatus HTTP_STATUS = HttpStatus.BAD_REQUEST;
	

	
	
	public BadRequestException(String hostId, String requestId, String errCode,
			String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}

	public BadRequestException(String hostId, String requestId, String errCode,
			String message) {
		this(hostId, requestId, errCode, message, null);
	}
	
	
	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}
	

}
