package com.xdja.cssp.restful.exception;

import org.springframework.http.HttpStatus;


/**
 * 身份未认证
 * <br>Http状态码 401
 * @author zhouyj
 *
 */
public class UnauthorizedException extends ApiException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5828722368805746792L;
	
	public static final HttpStatus HTTP_STATUS = HttpStatus.UNAUTHORIZED;
	

	@Override
	public int getStatus() {
		return HTTP_STATUS.value();
	}

	public UnauthorizedException(String hostId, String requestId,
			String errCode, String message) {
		this(hostId, requestId, errCode, message, null);
	}

	public UnauthorizedException(String hostId, String requestId,
			String errCode, String message, Throwable cause) {
		super(hostId, requestId, errCode, message, cause);
	}
	
	

}
