package com.xdja.cssp.restful.exception.handler;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import com.xdja.cssp.restful.auth.exception.AuthException;
import com.xdja.cssp.restful.exception.ApiException;
import com.xdja.cssp.restful.exception.ApiExceptionResponse;


/**
 * 异常处理类，将实际的异常转换为异常json字符串返回给客户端，
 * 并且根据异常类型返回对应的状态码
 * @author zhouyj
 *
 */
@ControllerAdvice
public class ApiExceptionHandler {
	
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
//	@Autowired
//	private ILogBusiness logBusiness;
	
	
	/**
	 * 处理非法请求
	 * @param exception
	 * @return
	 */
	@ExceptionHandler(value = ApiException.class)
	@ResponseBody
	public Object handleApiException(ApiException exception, HttpServletResponse httpservletResponse) {
		saveLog(exception);
		httpservletResponse.setStatus(exception.getStatus());
		return convert(exception);
	}
	

	/**
	 * 转换异常为对应的异常返回对象
	 * @param exception
	 * @return
	 */
	public ApiExceptionResponse convert(ApiException exception) {
		ApiExceptionResponse response = new ApiExceptionResponse();
		response.setRequestId(exception.getRequestId());
		response.setHostId(exception.getHostId());
		response.setErrCode(exception.getErrCode());
		response.setMessage(exception.getMessage());
		logger.debug("error response:" + response.toString(), exception);
		return response;
	}
	

	public void saveLog(ApiException exception) {
//		Log log;
//		if(exception.getCause() == null) {
//			log = new Log(exception.getHostId(), exception.getRequestId(), null, exception.getStatus(), 
//					exception.getErrCode(), exception.getMessage(), null, System.currentTimeMillis());
//		}else {
//			log = new Log(exception.getHostId(), exception.getRequestId(), null, exception.getStatus(), 
//					exception.getErrCode(), exception.getMessage(), exception.getCause().getMessage(), System.currentTimeMillis());
//		}
//		
//		try {
//			logBusiness.saveLog(log);
//		} catch (Exception e) {
//			logger.error("记录错误日志异常", e);
//		}
	}
	
	public void saveLog(AuthException exception) {
//		Log log;
//		if(exception.getCause() == null) {
//			log = new Log(exception.getHostId(), exception.getRequestId(), null, exception.getStatus(), 
//					exception.getErrCode(), exception.getMessage(), null, System.currentTimeMillis());
//		}else {
//			log = new Log(exception.getHostId(), exception.getRequestId(), null, exception.getStatus(), 
//					exception.getErrCode(), exception.getMessage(), exception.getCause().getMessage(), System.currentTimeMillis());
//		}
//		
//		try {
//			logBusiness.saveLog(log);
//		} catch (Exception e) {
//			logger.error("记录错误日志异常", e);
//		}
	}
}
