/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.generated.service.impl;

import com.xdja.cssp.generated.business.IGeneratedBusiness;
import com.xdja.cssp.generated.service.IGeneratedKeyService;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.redis.core.RedisClient;
import com.xdja.platform.redis.core.RedisClientConfig;
import com.xdja.platform.redis.core.RedisClientFactory;
import com.xdja.platform.redis.core.action.JedisAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisException;

@Component
public class GeneratedServiceImpl
implements IGeneratedKeyService,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(GeneratedServiceImpl.class);
    private static Prop prop = PropKit.use((String)"system.properties");
    private static RedisClient client;
    private static List<String> generatedPool;
    @Autowired
    private IGeneratedBusiness business;
    private static final Long ID_ERROR;

    public Long generateId(String serialType) {
        Long id = ID_ERROR;
        if (!generatedPool.contains(serialType)) {
            try {
                if (!this.business.loadId(serialType)) {
                    this.business.createNewID(serialType);
                    generatedPool.add(serialType);
                }
            }
            catch (Exception e) {
                logger.warn("\u4fdd\u5b58\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38....!!!!!!!!!!", (Throwable)e);
            }
        }
        try {
            id = (Long)client.execute((JedisAction)new GenIdAction(serialType));
        }
        catch (JedisException e) {
            logger.error("redis \u751f\u6210id \u51fa\u9519\uff1a", (Throwable)e);
        }
        return id;
    }

    private static void initRedisClient() {
        RedisClientConfig clientConfig = new RedisClientConfig();
        clientConfig.setHost(prop.get("redis.host"));
        clientConfig.setPort(prop.getInt("redis.port").intValue());
        client = RedisClientFactory.getClient((RedisClientConfig)clientConfig);
    }

    public void init() {
        logger.info("--------ID\u751f\u6210\u5668-----\u7cfb\u7edf\u521d\u59cb\u5316\u6570\u636e\u5f00\u59cb-----------------");
        List<Map<String, Object>> listData = this.business.queryGenerated();
        if (listData != null && listData.size() > 0) {
            for (Map<String, Object> data : listData) {
                logger.debug("\u652f\u6301{}\u4e1a\u52a1\u751f\u6210id.......", data.get("c_serial_type"));
                generatedPool.add(data.get("c_serial_type").toString());
            }
        }
        logger.info("RedisClient \u521d\u59cb\u5316\u5f00\u59cb....................");
        GeneratedServiceImpl.initRedisClient();
        logger.info("RedisClient \u521d\u59cb\u5316\u5b8c\u6210....................");
        logger.info("--------ID\u751f\u6210\u5668-----\u7cfb\u7edf\u521d\u59cb\u5316\u6570\u636e\u5b8c\u6210\uff0c\u5171\u52a0\u8f7d {}\u4e2a\u670d\u52a1................", (Object)listData.size());
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    static {
        generatedPool = new ArrayList<String>();
        ID_ERROR = -1L;
    }

    class GenIdAction
    implements JedisAction<Long> {
        private String key;

        public Long action(Jedis jedis) {
            return (long)jedis.incr(this.key);
        }

        public GenIdAction(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }
}

