/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.pmc.service;

import com.xdja.cssp.pmc.instruction.receiver.InitializationReceiver;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.core.spring.SpringBeanUtil;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.config.MicroServiceConfig;
import com.xdja.platform.microservice.db.DataSourceProvider;
import com.xdja.platform.microservice.db.druid.DruidPlugin;
import com.xdja.platform.microservice.db.nutz.NutzDaoPlugin;
import com.xdja.platform.microservice.plugin.IPlugin;
import com.xdja.platform.microservice.plugin.Plugins;
import com.xdja.platform.microservice.spring.SpringPlugin;
import com.xdja.platform.remoting.serialize.Serialization;
import com.xdja.platform.rpc.consumer.IService;
import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.consumer.ServicePool;
import com.xdja.platform.rpc.provider.ProviderStarter;
import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.pmc.unlock.UnlockCodeWrap;
import java.net.BindException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMCConfig
extends MicroServiceConfig {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String IP = "127.0.0.1";
    private static final int PORT = 6666;
    private static final int MAXWORKTHREAD = 100;

    public void configPlugin(Plugins me) {
        Prop prop = PropKit.use((String)"system.properties");
        String pmcUrl = prop.get("jdbc.pmc.url");
        if (StrKit.isBlank((String)pmcUrl)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0pmc-jdbcUrl\u7684\u914d\u7f6e", null);
        }
        String pmcUserName = prop.get("jdbc.pmc.userName");
        if (StrKit.isBlank((String)pmcUserName)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0pmc-userName\u7684\u914d\u7f6e", null);
        }
        String pmcPassword = prop.get("jdbc.pmc.password");
        DruidPlugin pmcdbPlugin = new DruidPlugin(pmcUrl, pmcUserName, pmcPassword);
        me.add((IPlugin)pmcdbPlugin);
        NutzDaoPlugin daoPlugin = new NutzDaoPlugin("db::pmc", (DataSourceProvider)pmcdbPlugin);
        if (!prop.getBoolean("jdbc.pmc.debug", Boolean.valueOf(true)).booleanValue()) {
            daoPlugin.disableDebug();
        }
        me.add((IPlugin)daoPlugin);
        String[] configLocations = new String[]{"classpath*:/META-INF/spring/applicationContext-*.xml", "classpath*:/applicationContext.xml"};
        me.add((IPlugin)new SpringPlugin(configLocations));
    }

    public void afterStart() {
        PagingConverter.pageNoMethodName = "getPageNumber";
        PagingConverter.pageSizeMethodName = "getPageSize";
        PagingConverter.totalCountMethodName = "getRecordCount";
        PagingConverter.totalPageMethodName = "getPageCount";
        PagingConverter.dataListMethodName = "getList";
        Prop prop = PropKit.use((String)"system.properties");
        String ip = prop.get("rpc.ip", IP);
        int port = prop.getInt("rpc.port", Integer.valueOf(6666));
        int maxWorkThread = prop.getInt("rpc.maxWorkThread", Integer.valueOf(100));
        try {
            String[] rpcServices;
            Service rpcService = null;
            for (String service : rpcServices = StringUtils.split((String)prop.get("rpc.services"), (String)"|")) {
                rpcService = new Service();
                rpcService.setAddr(prop.get("rpc." + service + ".ip"));
                rpcService.setPort(Integer.parseInt(prop.get("rpc." + service + ".port")));
                if (prop.containsKey("rpc." + service + ".serialization")) {
                    rpcService.setSerialization(Serialization.valueOf((String)prop.get("rpc." + service + ".serialization")));
                }
                if (prop.containsKey("rpc." + service + ".timeoutMillis")) {
                    rpcService.setTimeoutMillis(Long.valueOf(prop.get("rpc." + service + ".timeoutMillis")).longValue());
                }
                ServicePool.addService((String)service, (IService)rpcService);
                this.logger.debug("\u6ce8\u518c\u666e\u901arpc service\uff08{}==>{}:{}\uff09\u6210\u529f", new Object[]{service, rpcService.getAddr(), rpcService.getPort()});
            }
            ProviderStarter.NETTY.setMaxWorkThread(maxWorkThread).start(ip, port);
            this.logger.debug("====>PMC\u670d\u52a1{}:{}\u542f\u52a8\u6210\u529f\uff0c\u6700\u5927\u5de5\u4f5c\u7ebf\u7a0b\u6570\u4e3a{}\u4e2a\uff01", new Object[]{ip, port, maxWorkThread});
        }
        catch (BindException e) {
            this.logger.error("\u670d\u52a1\u7ed1\u5b9a\u5f02\u5e38", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.logger.error("\u7ebf\u7a0b\u5f02\u5e38", (Throwable)e);
        }
        InitializationReceiver initReceiver = (InitializationReceiver)SpringBeanUtil.getBean(InitializationReceiver.class);
        initReceiver.init();
        try {
            new UnlockCodeWrap();
            this.logger.debug("\u6210\u529f\u52a0\u8f7dSO\u6587\u4ef6");
        }
        catch (Throwable e) {
            this.logger.error("--->\u52a0\u8f7dSO\u6587\u4ef6\u5931\u8d25:" + e.getMessage());
        }
    }
}

