package com.xdja.cssp.ras.business.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.redis.core.RedisClient;
import com.xdja.platform.redis.core.RedisClientConfig;
import com.xdja.platform.redis.core.RedisClientFactory;

/**
 * redis工具类
 * @author liqi
 * @date 2015-2-28
 *
 */
public final class RedisUtil implements InitializingBean {

	private static final Logger logger = LoggerFactory.getLogger(RedisUtil.class);
	
 	private static RedisClient redisClient;
 	
 	public static RedisClient getRedisClient() {
		return redisClient;
	} 

	private static final String REDIS_MDM_PATH = "system.properties";
 	
 	private static final String REDIS_MDM_MAP_KEY = "mdmp_terminalCertMap";
 	
	@Override
	public void afterPropertiesSet() throws Exception {
		logger.info("开始初始化Redis缓存客户端");
		
		Prop redisProp = PropKit.use(REDIS_MDM_PATH);
	 	
	 	RedisClientConfig config = new RedisClientConfig();
	 	config.setHost(redisProp.get("redis.host"));
	 	config.setPort(Integer.parseInt(redisProp.get("redis.port")));
	 	config.setTimeout(Integer.parseInt(redisProp.get("redis.timeout")));
	 	config.setMaxTotal(redisProp.get("redis.maxTotal"));
	 	config.setMaxIdle(redisProp.get("redis.maxIdle"));
	 	
	 	redisClient = RedisClientFactory.getClient(config); 
	 	
	 	logger.info("初始化Redis缓存客户端成功");
	}
	
	public static void reload(RedisClientConfig config) {
		logger.info("重新初始化Redis缓存客户端");
		
 		redisClient = RedisClientFactory.getClient(config); 
 		
 		logger.info("重新初始化Redis缓存客户端成功");
	}
	
	public static void mdmHSet(String field, String value) { 
		redisClient.hset(REDIS_MDM_MAP_KEY, field, value); 
		logger.debug(String.format("write key field value is key[%s],field[%s],value[%s]", REDIS_MDM_MAP_KEY, field, value));
	}
	
	public static String mdmHget(String field) { 
		return redisClient.hget(REDIS_MDM_MAP_KEY, field); 
 	}
	 
	 
	 

}
