package com.xdja.cssp.ras.business.impl;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xdja.cssp.ras.service.Constant;
import com.xdja.platform.util.json.JSONUtil;
import com.xdja.sc.client.producer.SuperTransmitter;
import com.xdja.sc.model.Msg;

/**
 * SC通知工具类
 * @author wyf
 *
 */
public class SCNoticeUtil {
	
	private static Logger logger = LoggerFactory.getLogger(SCNoticeUtil.class);
	
	public static final String SC_TOP_USER_MODIFY_NOTICE = "userModifyNotice";
	
	/**
	 * 发送人员变更通知
	 * @param type 操作类型 1-增加；2-修改；3-删除
	 * @param accounts 变更人员账户
	 * @throws Exception 
	 */
	public static void sendUserModifyNotice(int type, List<String> accounts) throws Exception {
		String msgContent = null;
		try {
			if (null != accounts && accounts.size() > 0) {
				HashMap<String, Object> content = new HashMap<>();
				content.put("accounts", accounts);
				content.put("type", type);
				
				msgContent = JSONUtil.toJSONString(content);
				
				Msg msg = new Msg(); 
				msg.id = UUID.randomUUID().toString();
				msg.producer = Constant.SC_APP_ID;
				msg.timestamp = System.currentTimeMillis();
				msg.content = msgContent;
				msg.type = SC_TOP_USER_MODIFY_NOTICE;
				
				SuperTransmitter.getInstance().sendMessage(SC_TOP_USER_MODIFY_NOTICE, msg);
				
				logger.info("向SC发送人员变更通知成功，消息内容：{}", msgContent);
			}
		} catch (Exception e) {
			logger.error(String.format("向SC发送人员变更通知失败", msgContent), e);
			throw e;
		}
	}

}

