package com.xdja.cssp.ras.cache;

import java.sql.SQLException;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Map;
import java.util.Random;

//import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xdja.cssp.ras.business.impl.CommonBusiness;
import com.xdja.cssp.ras.service.Constant;

/**
 * 账号缓存
 * @author wyf
 *
 */
public class AccountCache {
	
	private static Logger logger = LoggerFactory.getLogger(AccountCache.class);
	
	/**
	 * 账号缓存
	 */
//	private final static Map<String, String> ACCOUNTS = new HashMap<>();
	
	/**
     * 字符范围
     */
	private static final String RANDOM_STR = "0123456789";
	
	/**
	 * 保存并生成唯一账户
	 * @return 账户
	 * @throws SQLException 
	 */
	public static String bulidAccount() throws SQLException {
		
		Random r = new Random(System.nanoTime());
		StringBuffer tempAccount;
		
		do {
			tempAccount = new StringBuffer("s");
			for (int i = 0; i < Constant.ACCOUNT_LENGTH; i++) {
				tempAccount.append(RANDOM_STR.charAt(r.nextInt(RANDOM_STR.length())));
			}
		} while (CommonBusiness.checkAccountExist(tempAccount.toString()));
		
		return tempAccount.toString();
		
		//TODO:下面注释部分为使用缓存时启用
//		return process(null);
	}

	/**
	 * 验证账户是否存在
	 * @param account 账户
	 * @return true-存在；false-不存在
	 * <br/>注：当返回false时，账号已添加到账号缓存中
	 * @throws SQLException 
	 */
	public static boolean checkAccountExist(String account) throws SQLException {
		return CommonBusiness.checkAccountExist(account);
		
//		return StringUtils.isBlank(process(account));
	}
	
	/**
	 * 从缓存中删除账户信息
	 * @param account 账户
	 */
	public static void remove(String account) {
//		ACCOUNTS.remove(account);
	}
	
//	/**
//	 * 验证、生成账号处理过程
//	 * @param account 账号
//	 * @return 当account不为null或空字符串时，验证账号是否存在，不存在则添加缓存并返回当前账号；存在则返回null
//	 * <br/>当account为null或空字符串时，系统自动生成系统唯一账号、添加缓存并返回生成账号
//	 */
//	private synchronized static String process(String account) {
//		if (StringUtils.isNotBlank(account)) {
//			if (ACCOUNTS.containsKey(account)) {
//				return null;
//			}
//			
//			ACCOUNTS.put(account, account);
//			
//			return account;
//		} else {
//			Random r = new Random(System.nanoTime());
//			StringBuffer tempAccount;
//			
//			do {
//				tempAccount = new StringBuffer("s");
//				for (int i = 0; i < Constant.ACCOUNT_LENGTH; i++) {
//					tempAccount.append(RANDOM_STR.charAt(r.nextInt(RANDOM_STR.length())));
//				}
//			} while (ACCOUNTS.containsKey(tempAccount.toString()));
//			
//			ACCOUNTS.put(tempAccount.toString(), tempAccount.toString());
//			
//			return tempAccount.toString();
//		}
//	}
	
	/**
	 * 初始化账户缓存信息
	 */
	public static void init() {
		try {
			logger.info("开始初始化账号缓存");
			
//			List<String> maxAccount = CommonBusiness.getAccounts();
			
//			for (String item : maxAccount) {
//				ACCOUNTS.put(item, item);
//			}
//			logger.info("初始化账号缓存成功");
			logger.info("系统目前不启用账号缓存，无需初始化");
		} catch (Exception e) {
			logger.error("初始化账号缓存失败", e);
		}
	}

}
