package com.xdja.cssp.ras.service;

import java.net.BindException;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xdja.cssp.ras.cache.AccountCache;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.config.MicroServiceConfig;
import com.xdja.platform.microservice.db.DbUtilsPlugin;
import com.xdja.platform.microservice.db.druid.DruidPlugin;
import com.xdja.platform.microservice.plugin.Plugins;
import com.xdja.platform.microservice.spring.SpringPlugin;
import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.consumer.ServicePool;
import com.xdja.platform.rpc.provider.ProviderStarter;
import com.xdja.sc.client.core.MQSetting;

/**
 * 
 * ras系统启动入口
 * @date 2015-2-2
 * @author rrx
 *
 */
public class RASConfig extends MicroServiceConfig {

	private Logger logger = LoggerFactory.getLogger(getClass());
	
	@Override
	public void configPlugin(Plugins me) {
		Prop dbProp = PropKit.use("system.properties");
		
		String url = dbProp.get("jdbc.url");
		if (StrKit.isBlank(url)) {
			throw ServiceException.create("请在配置文件system.properties中添加jdbc.url的配置", null);
		}
		String userName = dbProp.get("jdbc.username");
		if (StrKit.isBlank(userName)) {
			throw ServiceException.create("请在配置文件system.properties中添加jdbc.username的配置", null);
		}
		String password = dbProp.get("jdbc.password");
		
		DruidPlugin dbPlugin = new DruidPlugin(url, userName, password);
		me.add(dbPlugin);
		
		DbUtilsPlugin daoPlugin = new DbUtilsPlugin(Constant.DB_RAS, dbPlugin);
		me.add(daoPlugin);
		
		String[] configLocations = new String[]{
				"classpath*:/META-INF/spring/applicationContext-*.xml",
				"classpath*:/applicationContext.xml"
		};
		me.add(new SpringPlugin(configLocations));
	}
	
	@Override
	public void afterStart() { 
		Prop systemProp = PropKit.use("system.properties");
		
		String ip = systemProp.get("rpc.ip");
		int port = systemProp.getInt("rpc.port");
		int maxWorkThread = systemProp.getInt("rpc.maxWorkThread");
		
		try {
			ProviderStarter.NETTY.setMaxWorkThread(maxWorkThread).start(ip, port);
			
			logger.debug("====>RAS服务{}:{}启动成功，最大工作线程数为{}个！", ip, port, maxWorkThread);
		} catch (BindException e) {
			logger.error("服务绑定异常", e.getMessage());
		} catch (InterruptedException e) {
			logger.error("线程异常", e.getMessage());
		}
		
		String[] services = StringUtils.split(systemProp.get("rpc.services"), "|");
		if (null != services && services.length > 0) {
			String rpcIp;
			int rpcPort;
			long rpcTimeoutMillis;
			Service service;
			for (int i = 0; i < services.length; i++) {
				rpcIp = systemProp.get("rpc." + services[i] + ".ip");
				rpcPort = systemProp.getInt("rpc." + services[i] + ".port");
				rpcTimeoutMillis = systemProp.getLong("rpc." + services[i] + ".timeoutMillis");
				
				service = new Service();
				service.setAddr(rpcIp);
				service.setPort(rpcPort);
				service.setTimeoutMillis(rpcTimeoutMillis);
				
				ServicePool.addService(services[i], service);
				
				logger.info("====>开始初始化RPC客户端配置，{}服务地址{}:{}", services[i], rpcIp, rpcPort);
			}
		}
		
		Constant.SC_IP = systemProp.get("sc.ip");
		Constant.SC_PORT = systemProp.get("sc.port");
		Constant.SC_APP_ACCOUNT = systemProp.get("sc.app.username");
		Constant.SC_APP_PASSWORD = systemProp.get("sc.app.password");
		Constant.SC_APP_ID = systemProp.get("sc.app.identify");
		
		try {
			logger.info("开始初始化SC客户端");
			
			String mqUrl = Constant.SC_IP + ":" + Constant.SC_PORT;
			
			MQSetting.init(Constant.SC_APP_ACCOUNT, Constant.SC_APP_PASSWORD, mqUrl, Constant.SC_APP_ID);
			
			logger.info("初始化SC客户端成功！");
		} catch(Exception ex) {
			logger.error("初始化SC客户端失败", ex);
			System.exit(1);
		}
		
		Prop configProp = PropKit.use("config.properties");
		
		int accountLength = configProp.getInt("accountLength");
		
		Constant.ACCOUNT_LENGTH = accountLength;

		AccountCache.init();
	}

}
