package com.xdja.cssp.ras.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xdja.cssp.ras.business.interfaces.ILoginBusiness;
import com.xdja.cssp.ras.service.bean.auth.AccountCardAuth;
import com.xdja.cssp.ras.service.bean.auth.CardAuth;
import com.xdja.cssp.ras.service.bean.auth.MobileAuth;
import com.xdja.cssp.ras.service.bean.auth.UserAuth;
import com.xdja.cssp.ras.service.bean.enums.AccountCardAuthStatus;
import com.xdja.cssp.ras.service.bean.enums.ChiperAuthStatus;
import com.xdja.cssp.ras.service.bean.enums.MobileAuthStatus;
import com.xdja.cssp.ras.service.bean.enums.UserAuthStatus;
import com.xdja.cssp.ras.service.bean.result.CardAuthResult;
import com.xdja.cssp.ras.service.interfaces.ILoginService;
import com.xdja.platform.util.json.JSONUtil;


/**
 * 登录认证业务实现类
 * @author liqi
 * @date 2015-2-5
 */
@Service
public class LoginServerImpl implements ILoginService {
	
	private static final Logger logger = LoggerFactory.getLogger(LoginServerImpl.class);

	@Autowired
	ILoginBusiness login;
	
	@Override
	public CardAuthResult cardAuth(CardAuth auth) throws IllegalArgumentException, Exception {
		try {
			
			logger.error("接收到的请求信息如下：");
			logger.error(JSONUtil.toJSONString(auth));
			
		} catch(Exception ex) {
			logger.error("json字符串转换出现异常!");
		}
		
		if(StringUtils.isBlank(auth.getCardNo())) {
			
			logger.error("证书的卡号参数为空");
			throw new IllegalArgumentException("证书的卡号参数为空");
		}
		
		if(StringUtils.isBlank(auth.getCertSn())) {
			
			logger.error("证书序列号参数为空");
			throw new IllegalArgumentException("证书序列号参数为空");
		} 
		
		if (auth.getCaAlg() > 2 || auth.getCaAlg() < 1) {
			
			logger.error("证书算法参数错误：" + auth.getCaAlg() );
			throw new IllegalArgumentException("证书算法参数错误：" + auth.getCaAlg() );
		}
		
		return login.cardAuth(auth);
	}

	@Override
	public ChiperAuthStatus chipAuth(CardAuth auth) throws IllegalArgumentException, IllegalArgumentException, Exception {
		
		try {
			
			logger.error("接收到的请求信息如下：");
			logger.error(JSONUtil.toJSONString(auth));
			
		} catch(Exception ex) {
			logger.error("json字符串转换出现异常!");
		}
		
		if(StringUtils.isBlank(auth.getCardNo())) { 
			logger.error("证书的卡号参数为空");
			throw new IllegalArgumentException("证书的卡号参数为空");
		}
		
		if(StringUtils.isBlank(auth.getCertSn())) { 
			logger.error("证书序列号参数为空");
			throw new IllegalArgumentException("证书的序列号参数为空");
		} 
		
		if (auth.getCaAlg() > 2 || auth.getCaAlg() < 1) {
			
			logger.error("证书算法参数错误：" + auth.getCaAlg() );
			throw new IllegalArgumentException("证书算法参数错误：" + auth.getCaAlg() );
		}
		
		return login.chipAuth(auth);
	}
	
	
	

	@Override
	public UserAuthStatus userAuth(UserAuth auth) throws IllegalArgumentException, Exception {
	
		try {
			
			logger.error("接收到的请求信息如下：");
			logger.error(JSONUtil.toJSONString(auth));
			
		} catch(Exception ex) {
			logger.error("json字符串转换出现异常!");
		}
		//1 校验参数
		//2 业务校验 
		
		if (StringUtils.isBlank(auth.getAccount())) {
			logger.error("传入账号为空");
			throw new IllegalArgumentException("传入账号为空");
		}
		
		if (StringUtils.isBlank(auth.getPwd())) { 
			
			logger.error("密码为空");
			throw new IllegalArgumentException("传入密码为空");
		}  
		
		if (StringUtils.isBlank(auth.getCardNo())) {
					
			logger.error("证书的卡号参数为空");
			throw new IllegalArgumentException("证书的卡号参数为空");
		}
		
		if (StringUtils.isBlank(auth.getCertSn())) {
			
			logger.error("证书序列号参数为空");
			throw new IllegalArgumentException("证书序列号参数为空");
		} 
		
		if (auth.getCaAlg() > 2 || auth.getCaAlg() < 1) {
			
			logger.error("证书算法参数错误：" + auth.getCaAlg() );
			throw new IllegalArgumentException("证书算法参数错误：" + auth.getCaAlg() );
		}
		
 		return login.userAuth(auth);
	}

	@Override
	public MobileAuthStatus mobileAuth(MobileAuth auth) {
		
		logger.debug("原始请求数据：{}", auth.toString());
		
		if (StringUtils.isBlank(auth.getMobile())) {
			logger.debug("手机号为空");
			throw new IllegalArgumentException("手机号为空");
		}
		
		if(!auth.getMobile().matches("^(13|14|15|17|18)[0-9]{9}$")) {
			logger.debug("手机号格式错误");
			throw new IllegalArgumentException("手机号格式错误");
		}
		
		if (StringUtils.isBlank(auth.getPwd())) { 
			logger.debug("密码为空");
			throw new IllegalArgumentException("密码为空");
		}  
		
		if (StringUtils.isBlank(auth.getCardNo())) {
			logger.error("卡号为空");
			throw new IllegalArgumentException("卡号为空");
		}
		
		if (StringUtils.isBlank(auth.getCertSn())) {
			logger.debug("证书SN参数为空");
			throw new IllegalArgumentException("证书SN参数为空");
		} 
		
		if (auth.getCaAlg() > 2 || auth.getCaAlg() < 1) {
			logger.debug("证书算法不在枚举类型内");
			throw new IllegalArgumentException("证书算法不在枚举类型内");
		}
		
		return login.mobileAuth(auth);
	}
	
	@Override
	public AccountCardAuthStatus accountCardAuth(AccountCardAuth auth) {

		logger.debug("原始请求数据：{}", auth.toString());
		
		if (StringUtils.isBlank(auth.getAccount())) {
			logger.debug("账号为空");
			throw new IllegalArgumentException("账号为空");
		}
		
		if (StringUtils.isBlank(auth.getCardNo())) {
			logger.debug("卡号为空");
			throw new IllegalArgumentException("卡号为空");
		}
		
		if (StringUtils.isBlank(auth.getCertSn())) {
			logger.debug("证书SN为空");
			throw new IllegalArgumentException("证书SN为空");
		}
		
		if (auth.getCaAlg() > 2 || auth.getCaAlg() < 1) {
			logger.debug("证书算法不在枚举类型内");
			throw new IllegalArgumentException("证书算法不在枚举类型内");
		}
		
 		return login.accountCardAuth(auth);
	}

}
