package com.xdja.cssp.ras.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xdja.cssp.ras.business.interfaces.IRegistBusiness;
import com.xdja.cssp.ras.service.bean.auth.DeviceBind;
import com.xdja.cssp.ras.service.bean.auth.Regist;
import com.xdja.cssp.ras.service.bean.auth.RegistMobile;
import com.xdja.cssp.ras.service.bean.enums.DeviceBindStatus;
import com.xdja.cssp.ras.service.bean.enums.DeviceTestStatus;
import com.xdja.cssp.ras.service.bean.result.DeviceBindResult;
import com.xdja.cssp.ras.service.bean.result.RegistMobileResult;
import com.xdja.cssp.ras.service.bean.result.RegistResult;
import com.xdja.cssp.ras.service.interfaces.IRegisterService;
import com.xdja.platform.util.json.JSONUtil;

/**
 * 注册信息业务实现类
 * @author liqi
 * @date 2015-2-4
 */ 
@Service
public class RegisterServiceImpl implements IRegisterService {

	private static final Logger logger = LoggerFactory.getLogger(RegisterServiceImpl.class);
	
	@Autowired
	IRegistBusiness registBus ;
	
	@Override
	public RegistResult registAccount(Regist regist) throws Exception {
		
		try {
			
			logger.error("接收到的请求信息如下：");
			logger.error(JSONUtil.toJSONString(regist));
			
		} catch(Exception ex) {
			logger.error("json字符串转换出现异常!");
		}
		
 		//1  校验输入数据合法性 
		//2 校验账户是否存在 
		//3 校验设备是否存在
		if(StringUtils.isBlank(regist.getAccount())) { 
			
			//安通账号：是账户的唯一凭证，只能注册时设置一次；仅支持6~20个字母、数字、下划线或减号，以字母开头。
			logger.error("账号参数为空");
			throw new IllegalArgumentException("传入账号为空");
		}  
		
		if(!regist.getAccount().matches("^[0-9a-zA-Z][0-9a-zA-Z_-]{5,19}$")) {
			logger.error("账号参数应该是6~20个字母、数字、下划线或减号，以字母开头：" + regist.getAccount());
			throw new IllegalArgumentException("传入账号不符合要求");
		}
		
		
		if(StringUtils.isBlank(regist.getPwd())) { 
			
			logger.error("密码参数为空");
			throw new IllegalArgumentException("传入密码参数为空");
		}
		
		if(StringUtils.isBlank(regist.getDeviceId())) {
			
			logger.error("设备标识参数为空");
			throw new IllegalArgumentException("设备标识参数为空");
		}
		
		
		if(StringUtils.isBlank(regist.getCardNo())) {
					
			logger.error("证书的卡号参数为空");
			throw new IllegalArgumentException("证书的卡号参数为空");
		}
		
		if(StringUtils.isBlank(regist.getCertSn())) {
			
			logger.error("证书序列号参数为空");
			throw new IllegalArgumentException("证书序列号参数为空");
		} 
		
		
		return registBus.regist(regist);
		 
	}
	
	@Override
	public DeviceBindResult registDevice(DeviceBind deviceBind)	throws Exception {
		
		try {
			
			logger.error("接收到的请求信息如下：");
			logger.error(JSONUtil.toJSONString(deviceBind));
			
		} catch(Exception ex) {
			logger.error("json字符串转换出现异常!");
		}
		
		if(StringUtils.isBlank(deviceBind.getAccount())) { 
			//安通账号：是账户的唯一凭证，只能注册时设置一次；仅支持6~20个字母、数字、下划线或减号，以字母开头。
			logger.error("账号参数为空");
			throw new IllegalArgumentException("传入账号为空");
		}  
		
		
		if(StringUtils.isBlank(deviceBind.getPwd())) { 
			
			logger.error("密码参数为空");
			throw new IllegalArgumentException("传入密码参数为空");
		}
		
		if(StringUtils.isBlank(deviceBind.getDeviceId())) {
			
			logger.error("设备标识参数为空");
			throw new IllegalArgumentException("设备标识参数为空");
		}
		
		
		if(StringUtils.isBlank(deviceBind.getCardNo())) {
					
			logger.error("证书的卡号参数为空");
			throw new IllegalArgumentException("证书的卡号参数为空");
		}
		
		if(StringUtils.isBlank(deviceBind.getCertSn())) {
			
			logger.error("证书序列号参数为空");
			throw new IllegalArgumentException("证书序列号参数为空");
		} 
		
		return new DeviceBindResult(DeviceBindStatus.NONSUPPORT_LOGIN_ACCOUNT_BIND);
		//return registBus.registDevice(deviceBind);
	}

	@Override
	public DeviceTestStatus registTest(DeviceBind deviceBind)
			throws IllegalArgumentException, Exception {
		
		try {
			
			logger.error("接收到的请求信息如下：");
			logger.error(JSONUtil.toJSONString(deviceBind));
			
		} catch(Exception ex) {
			logger.error("json字符串转换出现异常!");
		}
		
		if(StringUtils.isBlank(deviceBind.getAccount())) { 
			//安通账号：是账户的唯一凭证，只能注册时设置一次；仅支持6~20个字母、数字、下划线或减号，以字母开头。
			logger.error("账号参数为空");
			throw new IllegalArgumentException("传入账号为空");
		}  
		
		
		if(StringUtils.isBlank(deviceBind.getPwd())) { 
			
			logger.error("密码参数为空");
			throw new IllegalArgumentException("传入密码参数为空");
		}
		
		if(StringUtils.isBlank(deviceBind.getDeviceId())) {
			
			logger.error("设备标识参数为空");
			throw new IllegalArgumentException("设备标识参数为空");
		}
		
		
		if(StringUtils.isBlank(deviceBind.getCardNo())) {
					
			logger.error("证书的卡号参数为空");
			throw new IllegalArgumentException("证书的卡号参数为空");
		}
		
		if(StringUtils.isBlank(deviceBind.getCertSn())) {
			
			logger.error("证书序列号参数为空");
			throw new IllegalArgumentException("证书序列号参数为空");
		} 
		
		return registBus.registTest(deviceBind);
	}

	@Override
	public boolean checkMobile(String mobile) {
		if (StringUtils.isBlank(mobile)) {
			logger.error("手机号参数为空");
			throw new IllegalArgumentException("手机号参数为空");
		}
		return registBus.checkMobile(mobile);
	}

	@Override
	public RegistMobileResult registMobile(RegistMobile regist) {
		logger.debug("请求原始数据：{}", regist.toString());
		
		if (StringUtils.isBlank(regist.getMobile())) {
			logger.debug("手机号参数为空");
			throw new IllegalArgumentException("手机号为空");
		}
		
		if(!regist.getMobile().matches("^(13|14|15|17|18)[0-9]{9}$")) {
			logger.debug("手机号格式错误");
			throw new IllegalArgumentException("手机号格式错误");
		}
		
		if (StringUtils.isBlank(regist.getPwd())) {
			logger.debug("密码参数为空");
			throw new IllegalArgumentException("传入密码参数为空");
		}
		
		if (StringUtils.isBlank(regist.getDeviceId())) {
			logger.debug("设备标识参数为空");
			throw new IllegalArgumentException("设备标识参数为空");
		}
		
		if (StringUtils.isBlank(regist.getCardNo())) {
			logger.debug("证书的卡号参数为空");
			throw new IllegalArgumentException("证书的卡号参数为空");
		}
		
		if (StringUtils.isBlank(regist.getCertSn())) {
			logger.debug("证书序列号参数为空");
			throw new IllegalArgumentException("证书序列号参数为空");
		}
		
		return registBus.registMobile(regist);
	} 

}
