/*
 * Decompiled with CFR 0.152.
 */
package com.xm.permissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.AppOpsManagerCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import java.util.List;

public class PermissionUtils {
    public static boolean hasPermission(@NonNull Context context, @NonNull List<String> permissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String permission : permissions) {
            int result = ContextCompat.checkSelfPermission((Context)context, (String)permission);
            if (result == -1) {
                return false;
            }
            String op = AppOpsManagerCompat.permissionToOp((String)permission);
            if (TextUtils.isEmpty((CharSequence)op) || (result = AppOpsManagerCompat.noteProxyOp((Context)context, (String)op, (String)context.getPackageName())) == 0) continue;
            return false;
        }
        return true;
    }

    public static void goSettingActivity(@NonNull Activity activity, int requestCode) {
        Activity context = activity;
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
        intent.setData(uri);
        activity.startActivityForResult(intent, requestCode);
    }

    protected static boolean shouldShowRequestPermissionRationale(Activity activity, String ... permissions) {
        if (!PermissionUtils.isMarshmallow()) {
            return false;
        }
        return PermissionUtils.shouldShowRequestPermissionRationaleImplementation(activity, permissions);
    }

    @TargetApi(value=23)
    private static boolean shouldShowRequestPermissionRationaleImplementation(Activity activity, String ... permissions) {
        for (String p : permissions) {
            if (PermissionUtils.isGranted(activity, p) || activity.shouldShowRequestPermissionRationale(p)) continue;
            return false;
        }
        return true;
    }

    @TargetApi(value=23)
    protected static boolean isGranted(Activity activity, String permission) {
        return !PermissionUtils.isMarshmallow() || activity.checkSelfPermission(permission) == 0;
    }

    @TargetApi(value=23)
    protected static boolean isRevoked(Activity activity, String permission) {
        return PermissionUtils.isMarshmallow() && activity.getPackageManager().isPermissionRevokedByPolicy(permission, activity.getPackageName());
    }

    protected static boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }
}

