/*
 * Decompiled with CFR 0.152.
 */
package com.xm.permissions;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.xm.permissions.OnPermissionResult;
import com.xm.permissions.PermissionModel;
import com.xm.permissions.PermissionUtils;
import java.util.ArrayList;

public class PermissionsFragment
extends Fragment {
    private static final int PERMISSIONS_REQUEST_CODE = 42;
    private OnPermissionResult onPermissionResult;

    protected void setOnPermissionResult(OnPermissionResult onPermissionResult) {
        this.onPermissionResult = onPermissionResult;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    @TargetApi(value=23)
    protected void requestPermissions(@NonNull String[] permissions) {
        this.requestPermissions(permissions, 42);
    }

    @TargetApi(value=23)
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode != 42) {
            return;
        }
        ArrayList<PermissionModel> list = new ArrayList<PermissionModel>(permissions.length);
        for (String permission : permissions) {
            if (PermissionUtils.isGranted(this.getActivity(), permission)) {
                list.add(new PermissionModel(permission, true));
                continue;
            }
            if (PermissionUtils.isRevoked(this.getActivity(), permission)) {
                list.add(new PermissionModel(permission, false));
                continue;
            }
            list.add(new PermissionModel(permission, false));
        }
        for (PermissionModel p : list) {
            if (p.granted || this.onPermissionResult == null) continue;
            this.onPermissionResult.onFailed(!PermissionUtils.shouldShowRequestPermissionRationale(this.getActivity(), permissions));
            return;
        }
        if (this.onPermissionResult != null) {
            this.onPermissionResult.onSuccess();
        }
    }
}

