/*
 * Decompiled with CFR 0.152.
 */
package com.xm.permissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.support.annotation.NonNull;
import com.xm.permissions.OnPermissionResult;
import com.xm.permissions.PermissionUtils;
import com.xm.permissions.PermissionsFragment;
import java.util.ArrayList;

public class PermissionsManager {
    private static final String TAG = "PermissionsManager";
    private PermissionsFragment mRxPermissionsFragment;
    private String[] permissions;
    private OnPermissionResult onPermissionResult;

    public PermissionsManager(@NonNull Activity activity) {
        if (this.mRxPermissionsFragment == null) {
            this.mRxPermissionsFragment = this.getRxPermissionsFragment(activity);
        }
    }

    public PermissionsManager setPermissions(String[] permissions) {
        this.permissions = permissions;
        return this;
    }

    public PermissionsManager setOnPermissionResult(OnPermissionResult onPermissionResult) {
        this.onPermissionResult = onPermissionResult;
        return this;
    }

    private PermissionsFragment getRxPermissionsFragment(Activity activity) {
        boolean isNewInstance;
        PermissionsFragment rxPermissionsFragment = this.findRxPermissionsFragment(activity);
        boolean bl = isNewInstance = rxPermissionsFragment == null;
        if (isNewInstance) {
            rxPermissionsFragment = new PermissionsFragment();
            FragmentManager fragmentManager = activity.getFragmentManager();
            fragmentManager.beginTransaction().add((Fragment)rxPermissionsFragment, TAG).commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return rxPermissionsFragment;
    }

    private PermissionsFragment findRxPermissionsFragment(Activity activity) {
        return (PermissionsFragment)activity.getFragmentManager().findFragmentByTag(TAG);
    }

    public PermissionsManager request() {
        if (this.permissions == null || this.permissions.length == 0) {
            throw new IllegalArgumentException("permissions requires at least one input permission");
        }
        if (this.mRxPermissionsFragment != null) {
            this.mRxPermissionsFragment.setOnPermissionResult(this.onPermissionResult);
        }
        this.requestImplementation(this.permissions);
        return this;
    }

    @TargetApi(value=23)
    private void requestImplementation(String ... permissions) {
        ArrayList<String> unrequestedPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            if (this.mRxPermissionsFragment != null && PermissionUtils.isGranted(this.mRxPermissionsFragment.getActivity(), permission) || this.mRxPermissionsFragment != null && PermissionUtils.isRevoked(this.mRxPermissionsFragment.getActivity(), permission)) continue;
            unrequestedPermissions.add(permission);
        }
        if (!unrequestedPermissions.isEmpty()) {
            String[] unrequestedPermissionsArray = unrequestedPermissions.toArray(new String[unrequestedPermissions.size()]);
            this.requestPermissionsFromFragment(unrequestedPermissionsArray);
        } else if (this.onPermissionResult != null) {
            this.onPermissionResult.onSuccess();
        }
    }

    @TargetApi(value=23)
    private void requestPermissionsFromFragment(String[] permissions) {
        if (this.mRxPermissionsFragment != null) {
            this.mRxPermissionsFragment.requestPermissions(permissions);
        }
    }
}

