/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.EncryptedData;
import com.xdja.pki.itsca.oer.asn1.Opaque;
import com.xdja.pki.itsca.oer.asn1.SignedData;
import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Payload
extends Choice {
    private static Logger logger = LoggerFactory.getLogger(Payload.class);
    private Opaque unSecuredData;
    private SignedData signedData;
    private EncryptedData encData;

    public Payload(Opaque opaque) {
        this.unSecuredData = opaque;
        this.signedData = null;
        this.encData = null;
    }

    public Payload(SignedData signedData) {
        this.addIndex(1);
        this.unSecuredData = null;
        this.signedData = signedData;
        this.encData = null;
    }

    public Payload(EncryptedData encData) {
        this.addIndex(2);
        this.unSecuredData = null;
        this.signedData = null;
        this.encData = encData;
    }

    public Opaque getUnSecuredData() {
        return this.unSecuredData;
    }

    public SignedData getSignedData() {
        return this.signedData;
    }

    public EncryptedData getEncData() {
        return this.encData;
    }

    public static Payload getInstance(byte[] data) throws Exception {
        Payload payload;
        ByteArrayUtils.printHexBinary(logger, "Payload start data ", data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        if (choice.intValue() - 128 == 0) {
            logger.debug("Payload choice unSecuredData");
            OctetString instance = Opaque.getInstance(data);
            Opaque opaque = new Opaque();
            opaque.setString(instance.getString());
            opaque.setGoal(instance.getGoal());
            ByteArrayUtils.printHexBinary(logger, "Payload opaque data ", opaque.getEncode());
            payload = new Payload(opaque);
            payload.setGoal(opaque.getGoal());
        } else if (choice.intValue() - 128 == 1) {
            logger.debug("Payload choice signedData");
            SignedData signedData = SignedData.getInstance(goal);
            payload = new Payload(signedData);
            payload.setGoal(signedData.getGoal());
            ByteArrayUtils.printHexBinary(logger, "Payload signedData data ", signedData.getEncode());
        } else if (choice.intValue() - 128 == 2) {
            logger.debug("Payload choice encryptedData");
            EncryptedData encryptedData = EncryptedData.getInstance(goal);
            payload = new Payload(encryptedData);
            payload.setGoal(encryptedData.getGoal());
            ByteArrayUtils.printHexBinary(logger, "Payload encryptedData data ", encryptedData.getEncode());
        } else {
            logger.debug("Payload choice is error " + choice.intValue());
            throw new Exception("unsupported Payload type " + choice.intValue());
        }
        ByteArrayUtils.printHexBinary(logger, "Payload lave data ", payload.getGoal());
        return payload;
    }

    @Override
    public Vector getChoiceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        if (null != this.unSecuredData) {
            vector.add(this.unSecuredData);
        }
        if (null != this.signedData) {
            vector.add(this.signedData);
        }
        if (null != this.encData) {
            vector.add(this.encData);
        }
        return vector;
    }
}

