/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.base.SequenceOf;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceOfCertificate
extends SequenceOf {
    private static Logger logger = LoggerFactory.getLogger(SequenceOfCertificate.class);
    private List<Certificate> certificates = new ArrayList<Certificate>();

    public List<Certificate> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(Certificate certificates) {
        this.certificates.add(certificates);
    }

    public void addCertificate(Certificate certificate) {
        super.addOERObject(certificate);
    }

    public static SequenceOfCertificate getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "SequenceOfCertificate start data ", data);
        BigInteger len = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        BigInteger length = BigIntegers.fromUnsignedByteArray((byte[])data, (int)1, (int)len.intValue());
        byte[] goal = new byte[data.length - 2];
        System.arraycopy(data, 2, goal, 0, goal.length);
        SequenceOfCertificate sequenceOfCertificate = new SequenceOfCertificate();
        for (int i = 0; i < length.intValue(); ++i) {
            Certificate instance = Certificate.getInstance(goal);
            sequenceOfCertificate.setCertificates(instance);
            goal = instance.getGoal();
            sequenceOfCertificate.addCertificate(instance);
            ByteArrayUtils.printHexBinary(logger, "SequenceOfCertificate  at index " + i + " Certificate data ", instance.getEncode());
        }
        sequenceOfCertificate.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "SequenceOfCertificate lave data ", goal);
        return sequenceOfCertificate;
    }
}

