/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.app.SignatureBuild;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.CertificateDigest;
import com.xdja.pki.itsca.oer.asn1.GeographicRegion;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.IssuerId;
import com.xdja.pki.itsca.oer.asn1.RectangularRegion;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidList;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidSspList;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRectangularRegion;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.cert.RectangularRegionBuilder;
import com.xdja.pki.itsca.oer.cert.TbsCertBuilder;
import com.xdja.pki.itsca.oer.enums.CertHashTypeEnum;
import com.xdja.pki.itsca.oer.enums.EccCurveTypeEnum;
import com.xdja.pki.itsca.oer.enums.EccPointTypeEnum;
import com.xdja.pki.itsca.oer.enums.SubjectTypeEnum;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateBuilder {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SequenceOfItsAidList itsAidList;
    private SequenceOfItsAidSspList itsAidSspList;
    private GeographicRegion geographicRegion;
    private Time32 startTime;
    private Time32 endTime;
    private EccPointTypeEnum signKeyEccPointType = EccPointTypeEnum.UNCOMPRESSED;
    private EccPointTypeEnum encKeyEccPointType = EccPointTypeEnum.UNCOMPRESSED;
    private EccCurveTypeEnum eccCurveTypeEnum;

    public void setSignKeyEccPointType(EccPointTypeEnum signKeyEccPointType) {
        this.signKeyEccPointType = signKeyEccPointType;
    }

    public void setEncKeyEccPointType(EccPointTypeEnum encKeyEccPointType) {
        this.encKeyEccPointType = encKeyEccPointType;
    }

    public void setEccCurveTypeEnum(EccCurveTypeEnum eccCurveTypeEnum) {
        this.eccCurveTypeEnum = eccCurveTypeEnum;
    }

    public void setStartTime(Time32 startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Time32 endTime) {
        this.endTime = endTime;
    }

    public void setItsAidList(SequenceOfItsAidList itsAidList) {
        this.itsAidList = itsAidList;
    }

    public void setItsAidSspList(SequenceOfItsAidSspList itsAidSspList) {
        this.itsAidSspList = itsAidSspList;
    }

    public void setGeographicRegion(GeographicRegion geographicRegion) {
        this.geographicRegion = geographicRegion;
    }

    public void setGeographicRegion(int northWestLatitude, int northWestLongitude, int southEastLatitude, int southEastLongitude) {
        this.geographicRegion = new GeographicRegion();
        SequenceOfRectangularRegion sequenceOfRectangularRegion = new SequenceOfRectangularRegion();
        RectangularRegionBuilder rectangularRegionBuilder = new RectangularRegionBuilder();
        RectangularRegion rectangularRegion = rectangularRegionBuilder.build(northWestLatitude, northWestLongitude, southEastLatitude, southEastLongitude);
        sequenceOfRectangularRegion.addRectangularRegion(rectangularRegion);
        this.geographicRegion.setRectangularRegion(sequenceOfRectangularRegion);
    }

    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, String subjectName, byte[] issuedHashId, SubjectTypeEnum subjectType) throws Exception {
        return this.build(privateKey, verifyPublicKey, encPublicKey, subjectName.getBytes(), CertHashTypeEnum.SGD_SM3, issuedHashId, subjectType);
    }

    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, byte[] subjectName, byte[] issuedHashId, SubjectTypeEnum subjectType) throws Exception {
        return this.build(privateKey, verifyPublicKey, encPublicKey, subjectName, CertHashTypeEnum.SGD_SM3, issuedHashId, subjectType);
    }

    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, String subjectName, CertHashTypeEnum hashType, byte[] issuedHashId, SubjectTypeEnum subjectType) throws Exception {
        return this.build(privateKey, verifyPublicKey, encPublicKey, subjectName.getBytes(), hashType, issuedHashId, subjectType);
    }

    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, byte[] subjectName, CertHashTypeEnum hashType, byte[] issuedHashId, SubjectTypeEnum subjectType) throws Exception {
        TbsCertBuilder tbsCertBuilder = new TbsCertBuilder();
        if (null != this.endTime) {
            tbsCertBuilder.setEndTime(this.endTime);
        }
        if (null != this.startTime) {
            tbsCertBuilder.setStartTime(this.startTime);
        }
        if (this.itsAidList != null) {
            tbsCertBuilder.setItsAidList(this.itsAidList);
        }
        if (this.itsAidSspList != null) {
            tbsCertBuilder.setItsAidSspList(this.itsAidSspList);
        }
        if (this.geographicRegion != null) {
            tbsCertBuilder.setGeographicRegion(this.geographicRegion);
        }
        tbsCertBuilder.setSignKeyEccPointType(this.signKeyEccPointType);
        tbsCertBuilder.setEncKeyEccPointType(this.encKeyEccPointType);
        tbsCertBuilder.setEccCurveTypeEnum(this.eccCurveTypeEnum);
        TbsCert tbsCert = tbsCertBuilder.build(verifyPublicKey, encPublicKey, subjectName, subjectType);
        return this.build(privateKey, hashType, issuedHashId, tbsCert);
    }

    public Certificate build(PrivateKey privateKey, CertHashTypeEnum hashType, byte[] issueHash, TbsCert tbsCert) throws Exception {
        Certificate certificate = new Certificate();
        ByteArrayUtils.printHexBinary(0, "Certificate SEQUENCE", null);
        ByteArrayUtils.printHexBinary(1, "Version Uint8 INTEGER", null);
        ByteArrayUtils.printHexBinary(1, "Version", ByteBuffer.allocate(2).putShort((short)2).array());
        IssuerId issuerId = new IssuerId();
        if (issueHash != null) {
            byte[] hashId;
            ByteArrayUtils.printHexBinary(1, "IssuerId CHOICE [index = 1]", null);
            ByteArrayUtils.printHexBinary(2, "CertificateDigest SEQUENCE", null);
            CertificateDigest certificateDigest = new CertificateDigest();
            ByteArrayUtils.printHexBinary(3, "HashAlgorithm ENUMERATED", null);
            HashAlgorithm hashAlgorithm = hashType.id == CertHashTypeEnum.SGD_SM3.id ? new HashAlgorithm(HashAlgorithm.SGD_SM3) : new HashAlgorithm(HashAlgorithm.SHA_256);
            certificateDigest.setHashAlgorithm(hashAlgorithm);
            ByteArrayUtils.printHexBinary(3, "HashAlgorithm", hashAlgorithm.getEncode());
            ByteArrayUtils.printHexBinary(3, "HashedId8 OCTER STRING", null);
            try {
                hashId = ByteArrayUtils.subByteHashId(issueHash, 8);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            HashedId8 hashedId8 = new HashedId8(hashId);
            certificateDigest.setHashedId8(hashedId8);
            ByteArrayUtils.printHexBinary(3, "HashedId8", hashedId8.getEncode());
            ByteArrayUtils.printHexBinary(2, "CertificateDigest", certificateDigest.getEncode());
            issuerId.setCertificateDigest(certificateDigest);
        } else {
            ByteArrayUtils.printHexBinary(1, "IssuerId CHOICE [index = 0]", null);
            Null aNull = new Null();
            issuerId.setSelf(aNull);
        }
        certificate.setIssuerId(issuerId);
        ByteArrayUtils.printHexBinary(1, "IssuerId", issuerId.getEncode());
        ByteArrayUtils.printHexBinary(1, "TbsCert", null);
        certificate.setTbsCert(tbsCert);
        ByteArrayUtils.printHexBinary(1, "TbsCert", tbsCert.getEncode());
        byte[] tbsEncode = tbsCert.getEncode();
        byte[] data = issueHash != null ? ByteArrayUtils.buildUpByte(GMSSLSM3DigestUtils.digestByYunhsm((byte[])tbsEncode), issueHash) : ByteArrayUtils.buildUpByte(GMSSLSM3DigestUtils.digestByYunhsm((byte[])tbsEncode), GMSSLSM3DigestUtils.digestByYunhsm((byte[])"".getBytes()));
        Signature signature = SignatureBuild.build(privateKey, data);
        certificate.setSignature(signature);
        ByteArrayUtils.printHexBinary(1, "Signature", signature.getEncode());
        ByteArrayUtils.printHexBinary(0, "Certificate", certificate.getEncode());
        return certificate;
    }
}

