/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.utils;

import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.provider.certpath.X509CertificatePair;

public class X509Utils {
    private static Logger logger = LoggerFactory.getLogger((String)X509Utils.class.getName());
    public static final int ECC_KEY_BITS = 256;
    public static final String ECC_ALGORITHM_NAME = "EC";
    public static final String ECC_SM2_NAME = "sm2p256v1";
    public static final String BRAINPOOL_P_256_R1 = "brainpoolP256r1";
    public static final String NIST_P_256 = "secp256r1";
    public static final String X509_TYPE_NAME = "X.509";

    public static KeyPair generateSM2KeyPair() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(ECC_ALGORITHM_NAME, "BC");
        kpGen.initialize(new ECGenParameterSpec(ECC_SM2_NAME), new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair generateBrainpoolP256R1KeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(ECC_ALGORITHM_NAME, "BC");
        kpGen.initialize(new ECGenParameterSpec(BRAINPOOL_P_256_R1), new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair generateNISTP256KeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(ECC_ALGORITHM_NAME, "BC");
        kpGen.initialize(new ECGenParameterSpec(NIST_P_256), new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static PublicKey convertSM2PublicKeyBitString(String base64) throws Exception {
        return X509Utils.convertSM2PublicKeyBitString(ByteArrayUtils.base64Decode(base64));
    }

    public static PublicKey convertSM2PublicKeyBitString(byte[] data) throws Exception {
        int digestLen = 32;
        byte[] x = new byte[digestLen];
        System.arraycopy(data, 1, x, 0, digestLen);
        byte[] y = new byte[digestLen];
        System.arraycopy(data, digestLen + 1, y, 0, digestLen);
        return X509Utils.convertSM2PublicKey(x, y);
    }

    public static String convertBitStringSM2PublicKey(ECPublicKey publicKey) throws Exception {
        return X509Utils.convertBitStringSM2PublicKey(publicKey.getW().getAffineX(), publicKey.getW().getAffineY());
    }

    public static String convertBitStringSM2PublicKey(BigInteger x, BigInteger y) throws Exception {
        return X509Utils.convertBitStringSM2PublicKey(ByteArrayUtils.asUnsignedByteArray32(x), ByteArrayUtils.asUnsignedByteArray32(y));
    }

    public static String convertBitStringSM2PublicKey(byte[] x, byte[] y) throws Exception {
        if (x.length != 32 || y.length != 32) {
            throw new Exception("x or y length error x: " + x.length + " y: " + y.length);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(4);
        outputStream.write(x);
        outputStream.write(y);
        return ByteArrayUtils.base64Encode(outputStream.toByteArray());
    }

    public static PublicKey convertSM2PublicKey(byte[] x, byte[] y) throws Exception {
        return X509Utils.convertSM2PublicKey(BigIntegers.fromUnsignedByteArray((byte[])x), BigIntegers.fromUnsignedByteArray((byte[])y));
    }

    public static PublicKey convertSM2PublicKey(BigInteger x, BigInteger y) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)ECC_SM2_NAME);
        ECCurve curve = ecParameterSpec.getCurve();
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(curve.createPoint(x, y), (ECParameterSpec)ecParameterSpec);
        return new BCECPublicKey(ECC_SM2_NAME, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static ECPublicKey decodePoint(boolean isOdd, byte[] x) {
        byte[] encode;
        byte[] bytes;
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)ECC_SM2_NAME);
        ECCurve curve = ecParameterSpec.getCurve();
        if (isOdd) {
            bytes = new byte[]{3};
            encode = ByteArrayUtils.buildUpByte(bytes, x);
        } else {
            bytes = new byte[]{2};
            encode = ByteArrayUtils.buildUpByte(bytes, x);
        }
        ECPoint ecPoint = curve.decodePoint(encode);
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecPoint, (ECParameterSpec)ecParameterSpec);
        return new BCECPublicKey(ECC_SM2_NAME, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static PrivateKey convertSM2PrivateKey(byte[] s) throws Exception {
        return X509Utils.convertSM2PrivateKey(new BigInteger(s));
    }

    public static PrivateKey convertSM2PrivateKey(BigInteger s) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)ECC_SM2_NAME);
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(s, (ECParameterSpec)ecParameterSpec);
        KeyFactory keyFactory = KeyFactory.getInstance(ECC_ALGORITHM_NAME, "BC");
        return keyFactory.generatePrivate((KeySpec)privateKeySpec);
    }

    public static PublicKey convertSM2PublicKey(SubjectPublicKeyInfo info) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        KeyFactory keyFactory = new DefaultJcaJceHelper().createKeyFactory(info.getAlgorithm().getAlgorithm().getId());
        return keyFactory.generatePublic(new X509EncodedKeySpec(info.getEncoded()));
    }

    public static PublicKey convertNISTPPublicKey(BigInteger x, BigInteger y) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)NIST_P_256);
        ECCurve curve = ecParameterSpec.getCurve();
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(curve.createPoint(x, y), (ECParameterSpec)ecParameterSpec);
        return new BCECPublicKey(ECC_ALGORITHM_NAME, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static PrivateKey convertNISTPPrivateKey(BigInteger s) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)NIST_P_256);
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(s, (ECParameterSpec)ecParameterSpec);
        KeyFactory keyFactory = KeyFactory.getInstance(ECC_ALGORITHM_NAME, "BC");
        return keyFactory.generatePrivate((KeySpec)privateKeySpec);
    }

    public static InputStream readFile(String path) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(path);
        if (inputStream == null) {
            inputStream = new FileInputStream(path);
        }
        return inputStream;
    }

    public static byte[] readFileBytes(String path) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(path);
        if (inputStream == null) {
            inputStream = new FileInputStream(path);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static PEMParser readPem(String path) throws Exception {
        InputStream inputStream = X509Utils.readFile(path);
        InputStreamReader reader = new InputStreamReader(inputStream);
        return new PEMParser((Reader)reader);
    }

    public static KeyPair readKeyPairFromPEM(String path) throws Exception {
        PEMParser pemParser = X509Utils.readPem(path);
        PEMKeyPair pemPair = (PEMKeyPair)pemParser.readObject();
        KeyPair keyPair = new JcaPEMKeyConverter().setProvider("BC").getKeyPair(pemPair);
        return keyPair;
    }

    public static X509Certificate readCertificateFromPEM(String path) throws Exception {
        PEMParser pemParser = X509Utils.readPem(path);
        X509CertificateHolder holder = (X509CertificateHolder)pemParser.readObject();
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_TYPE_NAME, "BC");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(holder.getEncoded());
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
        ((InputStream)inputStream).close();
        return certificate;
    }

    public static X509Certificate readCertificateFromCer(String path) throws Exception {
        FileInputStream inputStream = new FileInputStream(path);
        return X509Utils.readCertificateFromCerInputStream(inputStream);
    }

    public static X509Certificate readCertificateFromCerByte(byte[] encode) throws CertificateException, NoSuchProviderException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(encode);
        return X509Utils.readCertificateFromCerInputStream(inputStream);
    }

    public static X509Certificate readCertificateFromCerInputStream(InputStream inputStream) throws CertificateException, NoSuchProviderException {
        CertificateFactory factory = CertificateFactory.getInstance(X509_TYPE_NAME, "BC");
        return (X509Certificate)factory.generateCertificate(inputStream);
    }

    public static X509Certificate readCertificateFromP12(String filename, char[] pw) throws Exception {
        KeyStore kse = X509Utils.readKeyStoreFromP12(filename, pw);
        String alias = kse.aliases().nextElement();
        return (X509Certificate)kse.getCertificate(alias);
    }

    public static List<X509Certificate> readCertificatesFromP12(String filename, char[] pw) throws Exception {
        KeyStore kse = X509Utils.readKeyStoreFromP12(filename, pw);
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        if (kse.aliases().hasMoreElements()) {
            String alias = kse.aliases().nextElement();
            list.add((X509Certificate)kse.getCertificate(alias));
        }
        return list;
    }

    public static PublicKey readPublicKeyFromCer(String path) throws Exception {
        X509Certificate certificate = X509Utils.readCertificateFromCer(path);
        return certificate.getPublicKey();
    }

    public static PublicKey readPublicKeyFromPem(String path) throws Exception {
        PEMParser pemParser = X509Utils.readPem(path);
        SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)pemParser.readObject());
        return X509Utils.convertSM2PublicKey(info);
    }

    public static PublicKey readPublicKeyFromP12(String filename, char[] pw) throws Exception {
        KeyStore kse = X509Utils.readKeyStoreFromP12(filename, pw);
        String alias = kse.aliases().nextElement();
        return kse.getCertificate(alias).getPublicKey();
    }

    public static PrivateKey readPrivateKeyFromPem(String path) throws Exception {
        return X509Utils.readKeyPairFromPEM(path).getPrivate();
    }

    public static PrivateKey readPrivateKeyFromP12(String filename, char[] pw) throws Exception {
        KeyStore kse = X509Utils.readKeyStoreFromP12(filename, pw);
        String alias = kse.aliases().nextElement();
        return (PrivateKey)kse.getKey(alias, pw);
    }

    public static KeyStore readKeyStoreFromP12(String filename, char[] pw) throws Exception {
        KeyStore kse = KeyStore.getInstance("pkcs12", "BC");
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(filename);
        if (inputStream == null) {
            inputStream = new FileInputStream(filename);
        }
        kse.load(inputStream, pw);
        inputStream.close();
        return kse;
    }

    public static List<X509Certificate> getCertsByCertChain(InputStream inputStream) throws CMSException, CertificateException, IOException {
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        CMSSignedData cmsSignedData = new CMSSignedData(inputStream);
        Store store = cmsSignedData.getCertificates();
        Collection collection = store.getMatches(null);
        for (X509CertificateHolder x509CertificateHolder : collection) {
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolder);
            certificateList.add(x509Certificate);
        }
        inputStream.close();
        return certificateList;
    }

    public static String createCertChainByCerts(List<X509Certificate> certificateList) {
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        try {
            CMSProcessableByteArray msg = new CMSProcessableByteArray("".getBytes());
            JcaCertStore jcaCertStore = new JcaCertStore(certificateList);
            gen.addCertificates((Store)jcaCertStore);
            CMSSignedData signedData = gen.generate((CMSTypedData)msg);
            return new String(Base64.encode((byte[])signedData.getEncoded()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeSdfPrivateKey(String path, String name, PrivateKey privateKey) throws IOException {
        path = path + File.separator;
        FileWriter fileWritter = new FileWriter(path + name + ".pem", false);
        fileWritter.write(privateKey.toString());
        fileWritter.close();
    }

    public static void writeCertificateToCer(String path, String name, X509Certificate certificate) throws Exception {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String filename = path + name + ".cer";
        FileOutputStream out = new FileOutputStream(filename);
        out.write(certificate.getEncoded());
        out.close();
    }

    public static void writeCertificateToPem(String path, String name, X509Certificate certificate) throws Exception {
        X509Utils.writeObjectToPem(path, name, certificate);
    }

    public static void writePublicKeyToPem(String path, String name, PublicKey publicKey) throws Exception {
        X509Utils.writeObjectToPem(path, name, publicKey);
    }

    public static void writeObjectToPem(String path, String name, Object object) throws Exception {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String filename = path + name + ".pem";
        FileWriter writer = new FileWriter(filename);
        X509Utils.writePEM(object, writer);
        writer.close();
    }

    public static void writePEM(Object object, Writer writer) throws Exception {
        JcaPEMWriter pw = new JcaPEMWriter(writer);
        pw.writeObject(object);
        pw.flush();
        pw.close();
    }

    public static void writeKeyStoreToP12(KeyStore keyStore, char[] password, String path, String alias) throws Exception {
        KeyStore write = KeyStore.getInstance("PKCS12", "BC");
        write.load(null, null);
        write.setCertificateEntry(alias, keyStore.getCertificate(alias));
        if (keyStore.getKey(alias, password) != null) {
            write.setKeyEntry(alias, keyStore.getKey(alias, password), password, keyStore.getCertificateChain(alias));
        }
        FileOutputStream out = new FileOutputStream(path + alias + ".p12");
        write.store(out, password);
        out.close();
    }

    public static void writeKeyStoreToP12(KeyStore keyStore, char[] password, String p12file) throws Exception {
        KeyStore write = KeyStore.getInstance("PKCS12", "BC");
        write.load(null, null);
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (keyStore.getCertificate(alias) != null) {
                write.setCertificateEntry(alias, keyStore.getCertificate(alias));
            }
            if (keyStore.getKey(alias, password) == null) continue;
            write.setKeyEntry(alias, keyStore.getKey(alias, password), password, keyStore.getCertificateChain(alias));
        }
        FileOutputStream out = new FileOutputStream(p12file + ".p12");
        write.store(out, password);
        out.close();
    }

    public static void copyDir(String sourcePath, String bakPath) throws IOException {
        File sourceFile;
        String[] list;
        File bakFile = new File(bakPath);
        if (!bakFile.exists()) {
            bakFile.mkdir();
        }
        if ((list = (sourceFile = new File(sourcePath)).list()) != null) {
            for (String s : list) {
                if (new File(sourcePath + File.separator + s).isFile()) {
                    X509Utils.copyFile(sourcePath + File.separator + s, bakPath + File.separator + s);
                }
                if (!new File(sourcePath + File.separator + s).isDirectory()) continue;
                X509Utils.copyDir(sourcePath + File.separator + s, bakPath + File.separator + s);
            }
        }
    }

    public static void copyFile(String oldPath, String newPath) throws IOException {
        File oldFile = new File(oldPath);
        FileInputStream in = new FileInputStream(oldFile);
        X509Utils.copyFile(in, newPath);
    }

    public static void copyFile(FileInputStream inputStream, String newPath) throws IOException {
        File file = new File(newPath);
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[0x200000];
        int readByte = 0;
        while ((readByte = inputStream.read(buffer)) != -1) {
            out.write(buffer, 0, readByte);
        }
        inputStream.close();
        out.close();
    }

    public static boolean deleteDirectory(String sPath) {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = sPath + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = X509Utils.deleteFile(files[i].getAbsolutePath())) : !(flag = X509Utils.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
            }
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static boolean deleteFile(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            flag = file.delete();
        }
        return flag;
    }

    public static boolean verifyCert(X509Certificate cert, PublicKey publicKey) throws Exception {
        try {
            Certificate certificate = X509Utils.convertCertificate(cert);
            return X509Utils.verify(certificate.getSignatureAlgorithm(), publicKey, certificate.getTBSCertificate().getEncoded(), certificate.getSignature().getOctets());
        }
        catch (Exception e) {
            throw new Exception("exception processing signature: " + e, e);
        }
    }

    public static boolean verifyCRL(X509CRL crl, PublicKey publicKey) throws Exception {
        try {
            CertificateList certificateList = X509Utils.convertCRL(crl);
            return X509Utils.verify(certificateList.getSignatureAlgorithm(), publicKey, certificateList.getTBSCertList().getEncoded(), certificateList.getSignature().getOctets());
        }
        catch (Exception e) {
            throw new Exception("exception processing signature: " + e, e);
        }
    }

    public static boolean verifyCert(X509Certificate cert, List<X509Certificate> certificates) throws Exception {
        boolean flag = false;
        for (int i = 0; i < certificates.size(); ++i) {
            flag = X509Utils.verifyCert(cert, certificates.get(i).getPublicKey());
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public static boolean verify(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey, byte[] encoded, byte[] expected) throws Exception {
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
        ContentVerifier verifier = verifierProvider.get(algorithmIdentifier);
        OutputStream out = verifier.getOutputStream();
        out.write(encoded);
        out.close();
        return verifier.verify(expected);
    }

    public static AsymmetricKeyParameter convertECPublicKeyParameters(PublicKey publicKey) throws IOException {
        return PublicKeyFactory.createKey((SubjectPublicKeyInfo)SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()));
    }

    public static AsymmetricKeyParameter convertECPrivateKeyKeyParameters(PrivateKey privateKey) throws IOException {
        return PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfo.getInstance((Object)privateKey.getEncoded()));
    }

    public static SubjectPublicKeyInfo convertSubjectPublicKeyInfo(PublicKey publicKey) {
        return SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
    }

    public static Certificate convertCertificate(X509Certificate cert) throws CertificateEncodingException, IOException {
        return Certificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])cert.getEncoded()));
    }

    public static X509Certificate convertCertificate(Certificate cert) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_TYPE_NAME, "BC");
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
    }

    public static X509CRL convertCRL(CertificateList certificateList) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509_TYPE_NAME, "BC");
        return (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(certificateList.getEncoded()));
    }

    public static CertificateList convertCRL(X509CRL certificateList) throws Exception {
        return CertificateList.getInstance((Object)ASN1Primitive.fromByteArray((byte[])certificateList.getEncoded()));
    }

    public static org.bouncycastle.x509.X509CertificatePair convertCertificatePair(X509CertificatePair pair) throws Exception {
        return new org.bouncycastle.x509.X509CertificatePair(pair.getForward(), pair.getReverse());
    }

    public static X509CertificatePair convertCertificatePair(org.bouncycastle.x509.X509CertificatePair pair) throws Exception {
        return new X509CertificatePair(pair.getForward(), pair.getReverse());
    }

    public static boolean isCACertificate(X509Certificate certificate) {
        int basic = certificate.getBasicConstraints();
        return basic >= 0;
    }

    public static boolean isDRL(X509CRL crl) {
        Set<String> critical = crl.getCriticalExtensionOIDs();
        return critical != null && critical.contains(Extension.deltaCRLIndicator.getId());
    }

    public static boolean isARL(X509CRL crl) throws IOException {
        byte[] ext = crl.getExtensionValue(Extension.issuingDistributionPoint.getId());
        if (ext == null) {
            return false;
        }
        ASN1InputStream aIn = new ASN1InputStream(ext);
        ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
        aIn = new ASN1InputStream(octs.getOctets());
        ASN1Primitive idp = aIn.readObject();
        IssuingDistributionPoint p = IssuingDistributionPoint.getInstance((Object)idp);
        return p.onlyContainsCACerts();
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

