package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.EciesEncryptedKey;
import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.utils.ASN1SM2Cipher;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import org.bouncycastle.crypto.InvalidCipherTextException;

import java.io.IOException;
import java.security.PrivateKey;

/**
 * @ClassName KekResolveUtils
 * @Description TODO
 * @Date 2019/7/29 22:54
 * @Author FengZhen
 */
public class KekResolveUtils {
    public static byte[] getPlain(EciesEncryptedKey kek, PrivateKey privateKey) throws IOException, InvalidCipherTextException {
        EccPoint v = kek.getV();
        OctetString x = v.getUncompressed().getX();
        byte[] datass = new byte[32 + 32 + 32 + 16];
        System.arraycopy(x.getString(), 0, datass, 0, x.getString().length);
        OctetString y = v.getUncompressed().getY();
        System.arraycopy(y.getString(), 0, datass, 32, y.getString().length);
        System.arraycopy(kek.getT().getString(), 0, datass, 32 + 32, kek.getT().getString().length);
        System.arraycopy(kek.getC().getString(), 0, datass, 32 + 32 + 32, kek.getC().getString().length);

        ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(x.getString(), y.getString(), kek.getT().getString(), kek.getC().getString());
        return BCUtils.sm2DecryptASN1ByBC(privateKey, asn1SM2Cipher.getEncoded());
    }
}
