package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.itsca.oer.app.bean.PKRecipientInfoType;
import com.xdja.pki.itsca.oer.app.data.KekBuilder;
import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.utils.BCUtils;

import java.io.ByteArrayOutputStream;
import java.security.PrivateKey;

public class SecuredMessageBuilder {

    public static SecuredMessage buildSignedDataSecuredMessage(
            ItsAidInt itsAidInt,
            PrivateKey caPrivateKey,
            Certificate caCertificate,
            byte[] data
    ) throws Exception {
        SecuredMessage sign = new SecuredMessage();
        SignedData signedData = new SignedData();

        SequenceOfCertificate sequenceOfCertificate = new SequenceOfCertificate();
        sequenceOfCertificate.addCertificate(caCertificate);
        SignerInfo signerInfo = new SignerInfo(sequenceOfCertificate);
        signedData.setSignerInfo(signerInfo);

        TBSData tbsData = new TBSData();
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setItsAid(itsAidInt);
        tbsData.setHeaderInfo(headerInfo);
        tbsData.setData(data);
        signedData.setTbs(tbsData);

        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] pcaEncode = caCertificate.getEncode();
        byte[] pcaHash = BCUtils.sm3DigestByBC(pcaEncode);
        bos.write(pcaHash);
        byte[] tbsDataEncode = tbsData.getEncode();
        byte[] tbsHash = BCUtils.sm3DigestByBC(tbsDataEncode);
        bos.write(tbsHash);

        Signature signature = SignatureBuild.build(caPrivateKey, bos.toByteArray());
        signedData.setSign(signature);

        Payload payload = new Payload(signedData);
        sign.setPayload(payload);
        return sign;
    }

    public static SecuredMessage buildEncryptedDataSecuredMessage(Certificate caCertificate, byte[] data) throws Exception {
        SecuredMessage enc = new SecuredMessage();
        byte[] key = BCUtils.generateRandomByBC(16);
        EncryptedData encryptedData = new EncryptedData();

        SequenceOfRecipientInfo sequenceOfRecipientInfo = buildSequenceOfRecipientInfo(caCertificate, key);
        encryptedData.setRecipients(sequenceOfRecipientInfo);

        CipherText cipherText = new CipherText();
        byte[] cipher = BCUtils.symmetricECBEncryptByBC(true, BCUtils.EncryptTypeByBC.SM4_ECB_PKCS7Padding, key, data);

        cipherText.setString(cipher);

        SymmetricCipherText symmetricCipherText = new SymmetricCipherText(cipherText);
        encryptedData.setCipherText(symmetricCipherText);

        Payload payload = new Payload(encryptedData);
        enc.setPayload(payload);
        return enc;
    }

    public static SequenceOfRecipientInfo buildSequenceOfRecipientInfo(Certificate caCertificate, byte[] key) throws Exception {
        // ECA证书 公钥加密 对称密钥
        SequenceOfRecipientInfo sequenceOfRecipientInfo = new SequenceOfRecipientInfo();
        PKRecipientInfo certRecipInfo = new PKRecipientInfo();
        HashAlgorithm hashAlg = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        certRecipInfo.setHashAlg(hashAlg);
        //证书数据的OER编码做HashID8计算并对
        byte[] certHash = BCUtils.sm3DigestByBC(caCertificate.getEncode());
        byte[] certHashId8 = new byte[8];
        System.arraycopy(certHash, certHash.length - certHashId8.length, certHashId8, 0, certHashId8.length);
        HashedId8 recipientId = new HashedId8(certHashId8);
        certRecipInfo.setRecipientId(recipientId);
        // TODO: 2019/7/30
        EccPoint publicKey = caCertificate.getTbsCert().getSubjectAttribute().getVerifyKey().getEccPoint();
        EciesEncryptedKey kek = KekBuilder.build(publicKey, key);
        certRecipInfo.setKek(kek);
        RecipientInfo recipientInfo = new RecipientInfo(certRecipInfo, PKRecipientInfoType.CERT_RECIPINFO);
        sequenceOfRecipientInfo.addRecipientInfo(recipientInfo);
        return sequenceOfRecipientInfo;
    }
}
