package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.itsca.oer.asn1.*;

public class SecuredMessageHolder {

    private SecuredMessage securedMessage;
    private EncryptedData encryptedData;
    private SignedData signedData;

    public static SecuredMessage fromBytes(byte[] smEncode) throws Exception {
        return SecuredMessage.getInstance(smEncode);
    }

    public SecuredMessageHolder(byte[] smEncode) throws Exception {
        this(fromBytes(smEncode));
    }

    public SecuredMessageHolder(SecuredMessage securedMessage){
        this.securedMessage = securedMessage;
        Payload payload = this.securedMessage.getPayload();
        this.encryptedData = payload.getEncData();
        this.signedData = payload.getSignedData();
    }

    public SecuredMessage getSecuredMessage() {
        return securedMessage;
    }

    public EncryptedData getEncryptedData() {
        return encryptedData;
    }

    public SignedData getSignedData() {
        return signedData;
    }
}
