package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.crypto.CryptoException;

import java.io.IOException;
import java.security.PrivateKey;

/**
 *
 */
public class SignatureBuild {
    public static Signature build(PrivateKey privateKey, OERObject tobeSign) throws IOException {
        return build(privateKey, tobeSign.getEncode());
    }

    public static Signature build(PrivateKey privateKey, byte[] tbsEncode) throws IOException {
        byte[] r;
        byte[] s;
        try {
            byte[] sign = BCUtils.sm2SignByBC(privateKey, tbsEncode);
            byte[][] derDecode = BCUtils.sm2SignDerDecode(sign);
            assert derDecode != null && derDecode.length == 2;
            r = derDecode[0];
            s = derDecode[1];
        } catch (CryptoException e) {
            throw new IOException(e);
        }
        ByteArrayUtils.printHexBinary(3, "Signature", null);
        Signature signature = new Signature();
        EccCurve eccCurve = new EccCurve(EccCurve.SGD_SM2);
        ByteArrayUtils.printHexBinary(4, "EccCurve", null);
        ByteArrayUtils.printHexBinary(5, "EccCurve  SGD_SM2", null);
        signature.setEccCurve(eccCurve);
        signature.setR(r);
        ByteArrayUtils.printHexBinary(4, "r", r);
        signature.setS(s);
        ByteArrayUtils.printHexBinary(4, "s", s);
        return signature;
    }
}
