package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.itsca.oer.app.bean.PKRecipientInfoType;
import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.utils.BCUtils;

/***
 *---3. ECA加密身份验证消息体
 * EcSignature ::= SecuredMessage
 * SecuredMessage ::= SEQUENCE{
 *     version  Uint8,
 *     payload  Payload
 * }
 * Payload ::= CHOICE{
 *     unSecuredData   Opaque,
 *     signedData      SignedData,
 *     encData         EncryptedData --- 加密消息体
 * }
 * EncryptedData ::= SEQUENCE{
 *     recipients  SequenceOfRecipientInfo, ---ECA证书 公钥加密 对称密钥
 *     cipherText  SymmetricCipherText  ---对称密钥加密消息体 原文为 “4. SignedExternalPayload”
 * }
 */
public class EcSignatureBuilder {

    public static EcSignature build(SecuredMessage signedExternalPayload, byte[] key, Certificate ecaCertificate) throws Exception {
        EncryptedData encryptedData = new EncryptedData();
        //SM4ECB
        byte[] cipher = BCUtils.symmetricECBEncryptByBC(true, BCUtils.EncryptTypeByBC.SM4_ECB_PKCS7Padding, key,
                signedExternalPayload.getEncode());
        CipherText cipherText = new CipherText();
        cipherText.setString(cipher);
        SymmetricCipherText symmetricCipherText = new SymmetricCipherText(cipherText);
        encryptedData.setCipherText(symmetricCipherText);
        SequenceOfRecipientInfo sequenceOfRecipientInfo = new SequenceOfRecipientInfo();
        PKRecipientInfo certRecipInfo = new PKRecipientInfo();
        HashAlgorithm hashAlg = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        certRecipInfo.setHashAlg(hashAlg);
        //证书数据的OER编码做HashID8计算并对
        byte[] certHash = BCUtils.sm3DigestByBC(ecaCertificate.getEncode());
        byte[] certHashId8 = new byte[8];
        System.arraycopy(certHash, certHash.length - certHashId8.length, certHashId8, 0, certHashId8.length);
        HashedId8 recipientId = new HashedId8(certHashId8);
        certRecipInfo.setRecipientId(recipientId);
        EccPoint publicKey = ecaCertificate.getTbsCert().getSubjectAttribute().getEncryptionKey().getPublicKey();
        EciesEncryptedKey kek = KekBuilder.build(publicKey, key);
        certRecipInfo.setKek(kek);
        RecipientInfo recipientInfo = new RecipientInfo(certRecipInfo, PKRecipientInfoType.CERT_RECIPINFO);
        sequenceOfRecipientInfo.addRecipientInfo(recipientInfo);
        encryptedData.setRecipients(sequenceOfRecipientInfo);
        Payload payload = new Payload(encryptedData);
        EcSignature securedMessage = new EcSignature();
        securedMessage.setPayload(payload);
        return securedMessage;
    }

}
