package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.utils.ASN1SM2Cipher;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.X509Utils;
import org.bouncycastle.util.BigIntegers;

import java.security.PublicKey;

/**
 * @ClassName KekBuilder
 * @Description TODO
 * @Date 2019/7/29 15:39
 * @Author FengZhen
 */
public class KekBuilder {
    public static EciesEncryptedKey build(EccPoint eccPoint, byte[] key) throws Exception {
        EciesEncryptedKey kek = new EciesEncryptedKey();
        byte[] x = eccPoint.getUncompressed().getX().getString();
        byte[] y = eccPoint.getUncompressed().getY().getString();
        PublicKey publicKey = X509Utils.convertSM2PublicKey(x, y);
        byte[] cipher = BCUtils.sm2EncryptASN1ByBC(publicKey, key);
        ASN1SM2Cipher asn1SM2Cipher = ASN1SM2Cipher.getInstance(cipher);
        kek.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
        EccPoint v = new EccPoint();
        Uncompressed vu = new Uncompressed();
        vu.setX(BigIntegers.asUnsignedByteArray(asn1SM2Cipher.getxCoordinate()));
        vu.setY(BigIntegers.asUnsignedByteArray(asn1SM2Cipher.getyCoordinate()));
        v.setUncompressed(vu);
        kek.setV(v);
        kek.setC(asn1SM2Cipher.getCipherText());
        kek.setT(asn1SM2Cipher.getHash());
        return kek;
    }
}
