package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.itsca.oer.asn1.CertRequest;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;

/***
 *  *NormalCertRequestSign ::= SecureMessage(WITH COMPONENTS { ...,
 *  * 	version(2),
 *  * 	payload(WITH COMPONENTS { ...,
 *  * 		signedData(WITH COMPONENTS { ...,
 *  * 			signer(WITH COMPONENTS {
 *  * 				SequenceOfCertificate(SIZE(1))
 *  *                        }),
 *  * 			tbs(WITH COMPONENTS { ...,
 *  * 				headerInfo(WITH COMPONENTS { ...,
 *  * 					itsAid(40963),
 *  * 					hashAlg PRESENT,
 *  * 					genTime PRESENT,
 *  * 					expiryTime ABSENT,
 *  * 					digest ABSENT,
 *  * 					encKey  ABSENT
 *  *                }),
 *  * 				data( CONTAINING NormalCertRequestEnc ),
 *  * 				extHash  ABSENT
 *  *            })* 		})
 *  *    })
 *  * })
 *  * NormalCertRequestEnc ::= SecureMessage(WITH COMPONENTS { ...,
 *  * 	version(2),
 *  * 	payload(WITH COMPONENTS { ...,
 *  * 		encData(WITH COMPONENTS { ...,
 *  * 			recipients(SequenceOfRecipientInfo (SIZE(1)) (CONSTRAINED BY {
 *  * 				RecipientInfo(WITH COMPONENTS {
 *  * 					certRecipInfo
 *  *                                })* 			}        ))
 *  *    })
 *  * 	})
 *  * })
 *  *
 */
public class NormalCertRequestEnc extends CertDataBuilder {
    /**
     * @param certRequest 证书请求
     * @param key         对称密钥 16位
     * @return NormalCertRespData   F.3.2　非注册证书应答数据格式
     */
    public SecuredMessage build(CertRequest certRequest, byte[] key) throws Exception {
        return super.buildSecuredMessage(certRequest, false, key, certRequest.getEncode());
    }
}
