package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.itsca.oer.app.bean.PKRecipientInfoType;
import com.xdja.pki.itsca.oer.asn1.*;
import com.xdja.pki.itsca.oer.utils.BCUtils;

import java.io.IOException;

/***
 *-- 1. PseudonymCertRequestEnc 请求消息体
 * PseudonymCertRequestEnc := SecuredMessage
 * SecuredMessage ::= SEQUENCE{
 *     version  Uint8,
 *     payload  Payload
 * }
 * Payload ::= CHOICE{
 *     unSecuredData   Opaque,
 *     signedData      SignedData,
 *     encData         EncryptedData ---选择这个
 * }
 * EncryptedData ::= SEQUENCE{
 *     recipients  SequenceOfRecipientInfo, ---PCA证书公钥加密 对称密钥
 *     cipherText  SymmetricCipherText ---对称密钥加密 “2. 请求数据” 密文
 * }
 */
public class PseudonymCertRequestEncBuilder {
    public static SecuredMessage build(SecuredMessage securedMessage,byte[] key, Certificate pcaCertificate) throws Exception {
        EncryptedData encryptedData = new EncryptedData();
        //SM4ECB
        byte[] cipher = BCUtils.symmetricECBEncryptByBC(true, BCUtils.EncryptTypeByBC.SM4_ECB_PKCS7Padding, key,
                securedMessage.getEncode());
        CipherText cipherText = new CipherText();
        cipherText.setString(cipher);
        SymmetricCipherText symmetricCipherText = new SymmetricCipherText(cipherText);
        encryptedData.setCipherText(symmetricCipherText);
        SequenceOfRecipientInfo sequenceOfRecipientInfo = new SequenceOfRecipientInfo();
        PKRecipientInfo certRecipInfo = new PKRecipientInfo();
        HashAlgorithm hashAlg = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        certRecipInfo.setHashAlg(hashAlg);
        //证书数据的OER编码做HashID8计算并对
        byte[] certHash = BCUtils.sm3DigestByBC(pcaCertificate.getEncode());
        byte[] certHashId8 = new byte[8];
        System.arraycopy(certHash, certHash.length - certHashId8.length, certHashId8, 0, certHashId8.length);
        HashedId8 recipientId = new HashedId8(certHashId8);
        certRecipInfo.setRecipientId(recipientId);
        EccPoint publicKey = pcaCertificate.getTbsCert().getSubjectAttribute().getEncryptionKey().getPublicKey();
        EciesEncryptedKey kek = KekBuilder.build(publicKey, key);
        certRecipInfo.setKek(kek);
        RecipientInfo recipientInfo = new RecipientInfo(certRecipInfo, PKRecipientInfoType.CERT_RECIPINFO);
        sequenceOfRecipientInfo.addRecipientInfo(recipientInfo);
        encryptedData.setRecipients(sequenceOfRecipientInfo);
        Payload payload = new Payload(encryptedData);
        SecuredMessage secured= new SecuredMessage();
        secured.setPayload(payload);
        return secured;
    }
}
