package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigInteger;
import java.util.Vector;

/**
 * @ClassName EcSignature
 * @Description TODO
 * @Date 2019/7/29 14:43
 * @Author FengZhen
 */
public class EcSignature extends SecuredMessage {
    private static Logger logger = LoggerFactory.getLogger(EcSignature.class);
    private Payload payload;
    private int version;

    public EcSignature() {
        super();
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Payload getPayload() {
        return payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public static EcSignature getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "EcSignature start data", data);
        EcSignature ecSignature = new EcSignature();
        BigInteger integer = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        ecSignature.setVersion(integer.intValue());
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        Payload payload = Payload.getInstance(goal);
        ecSignature.setPayload(payload);
        ByteArrayUtils.printHexBinary(logger, "EcSignature payload data", payload.getEncode());
        ecSignature.setGoal(payload.getGoal());
        ByteArrayUtils.printHexBinary(logger, "EcSignature lave data", ecSignature.getGoal());
        return ecSignature;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        //version
        vector.add(2);
        vector.add(payload);
        return vector;
    }
}
